% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{as.data.frame.neuronlist}
\alias{as.data.frame.neuronlist}
\title{Extract the attached data.frame from a neuronlist}
\usage{
\method{as.data.frame}{neuronlist}(x, row.names = names(x),
  optional = FALSE, ...)
}
\arguments{
\item{x}{neuronlist to convert}

\item{row.names}{row names (defaults to names of objects in neuronlist, which
is nearly always what you want.)}

\item{optional}{ignored in this method}

\item{...}{additional arguments passed to \code{\link{data.frame}} (see
examples)}
}
\value{
a \code{data.frame} with length(x) rows, named according to names(x)
  and containing the columns from the attached data.frame, when present.
}
\description{
When there is no attached data.frame the result will be data.frame with 0
columns but an appropriate number of rows, named by the objects in the
neuronlist.
}
\examples{
head(as.data.frame(kcs20))

# add additional variables
str(as.data.frame(kcs20, i=seq(kcs20), abc=LETTERS[seq(kcs20)]))
# stop character columns being turned into factors
str(as.data.frame(kcs20, i=seq(kcs20), abc=LETTERS[seq(kcs20)],
  stringsAsFactors=FALSE))
}
\seealso{
\code{\link{data.frame}}, \code{\link{neuronlist}}
}

