\name{im3d-io}
\alias{im3d-io}
\alias{read.im3d}
\alias{write.im3d}
\title{Read/Write calibrated 3D blocks of image data}
\usage{
read.im3d(file, ReadData = TRUE, SimplifyAttributes = FALSE,
  ReadByteAsRaw = FALSE, ...)

write.im3d(x, file, ...)
}
\arguments{
  \item{file}{Character vector describing a single file}

  \item{ReadData}{Whether to read the data itself or return
  metadata only.  Default: TRUE}

  \item{SimplifyAttributes}{When \code{TRUE} leave only
  core im3d attributes.}

  \item{ReadByteAsRaw}{Whether to read byte values as R
  \code{\link{raw}} arrays. These occupy 1/4 memory but
  arithmetic is less convenient.  (default: FALSE)}

  \item{...}{Arguments passed to methods}

  \item{x}{The image data to write (an im3d, or capable of
  being interpreted as such)}
}
\value{
For \code{read.im3d} an objecting inheriting from base
\code{array} and \code{im3d} classes.
}
\description{
Read/Write calibrated 3D blocks of image data
}
\details{
Currently only nrrd and amira formats are implemented.
Furthermore implementing a registry to allow extension to
arbitrary formats remains a TODO item.
}
\seealso{
\code{\link{read.nrrd}, \link{read.amiramesh}}

\code{\link{write.nrrd}}

Other im3d: \code{\link{as.im3d}},
\code{\link{as.im3d.im3d}}; \code{\link{boundingbox}},
\code{\link{boundingbox.default}},
\code{\link{boundingbox.im3d}},
\code{\link{boundingbox<-}}; \code{\link{ijkpos}},
\code{\link{ijkpos}}, \code{\link{im3d-coords}},
\code{\link{im3d-coords}}, \code{\link{xyzpos}};
\code{\link{im3d}}; \code{\link{imexpand.grid}};
\code{\link{imslice}}; \code{\link{origin}};
\code{\link{projection}}; \code{\link{threshold}},
\code{\link{threshold.im3d}}; \code{\link{unmask}};
\code{\link{voxdims}}, \code{\link{voxdims.default}}
}

