% Generated by roxygen2 (4.0.2): do not edit by hand
\name{nhclust}
\alias{nhclust}
\title{Cluster a set of neurons}
\usage{
nhclust(neuron_names, method = "ward", scoremat = NULL, distfun = as.dist,
  ..., maxneurons = 4000)
}
\arguments{
\item{neuron_names}{character vector of neuron identifiers.}

\item{method}{clustering method (default Ward's).}

\item{scoremat}{score matrix to use (see \code{sub_score_mat} for details of
default).}

\item{distfun}{function to convert distance matrix returned by
\code{sub_dist_mat} into R dist object (default=as.dist).}

\item{...}{additional parameters passed to hclust.}

\item{maxneurons}{set this to a sensible value to avoid loading huge (order
N^2) distances directly into memory.}
}
\value{
An object of class \code{\link{hclust}} which describes the tree
  produced by the clustering process.
}
\description{
Given a vector of neuron identifiers use hclust to carry out a
hierarchical clustering. The default value of distfun will handle square
distance matrices and R.
}
\examples{
library(nat)
kcscores=nblast_allbyall(kcs20)
hckcs=nhclust(scoremat=kcscores)
# divide hclust object into 3 groups
library(dendroextras)
dkcs=colour_clusters(hckcs, k=3)
# change dendrogram labels to neuron type, extracting this information
# from type column in the metadata data.frame attached to kcs20 neuronlist
labels(dkcs)=with(kcs20[labels(dkcs)], type)
plot(dkcs)
# 3d plot of neurons in those clusters (with matching colours)
open3d()
plot3d(hckcs, k=3, db=kcs20)
# names of neurons in 3 groups
subset(hckcs, k=3)
}
\seealso{
\code{\link{hclust}, \link{dist}}

Other scoremats: \code{\link{sub_dist_mat}}
}

