% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringQC.R
\name{NanoStringQC}
\alias{NanoStringQC}
\title{QC metrics for NanoString Data}
\usage{
NanoStringQC(raw, exp, detect = 80, sn = 150)
}
\arguments{
\item{raw}{matrix of raw counts obtained from nCounter (rows represent genes,
columns represent samples). The first three columns must be labeled:
\code{c("Code.Class", "Name", "Accession")} and contain that information.}

\item{exp}{matrix of annotations with rows in the same order as the columns
of \code{raw}. Requires a column labeled \code{"File.Name"} with entries
corresponding to sample names in \code{raw}, also needs columns
\code{c("fov.counted", "fov.count", "binding.density")}.These fields can be
extracted from the nanostring RCC files.}

\item{detect}{threshold of percentage of genes expressed over limit of
detection (LOD) that we would like to detect (not decimal), defaults to 80
percent.}

\item{sn}{signal to noise ratio of the housekeeping genes we are willing to
tolerate, defaults to 150.}
}
\value{
matrix of annotations updated with normalization parameters
}
\description{
Computes and returns NanoString quality control metrics and flags.
}
\examples{
exp.OVD <- subset(expQC, OVD == "Yes")
expOVD <- NanoStringQC(ovd.r, exp.OVD)
}
\author{
Aline Talhouk, Derek Chiu
}
