# minitest - a minimal testing framework v0.0.2 --------------------------------
test_library <- function(package) library(package = package, character.only = TRUE)
test_true <- function(x) invisible(isTRUE(x) || {print(x); stop("the above was returned instead of TRUE")})
test_null <- function(x) invisible(is.null(x) || {print(x); stop("the above was returned instead of NULL")})
test_notnull <- function(x) invisible(!is.null(x) || stop("returns NULL when expected to be not NULL"))
test_zero <- function(x) invisible(x == 0L || {print(x); stop("the above was returned instead of 0L")})
test_type <- function(type, x) invisible(typeof(x) == type || {stop("object of type '", typeof(x), "' was returned instead of '", type, "'")})
test_class <- function(class, x) invisible(inherits(x, class) || {stop("object of class '", paste(class(x), collapse = ", "), "' was returned instead of '", class, "'")})
test_equal <- function(a, b) invisible(a == b || {print(a); print(b); stop("the above expressions were not equal")})
test_identical <- function(a, b) invisible(identical(a, b) || {print(a); print(b); stop("the above expressions were not identical")})
test_print <- function(x) invisible(is.character(capture.output(print(x))) || stop("print output of expression cannot be captured as a character value"))
test_error <- function(x, containing = "") invisible(inherits(x <- tryCatch(x, error = identity), "error") && grepl(containing, x[["message"]], fixed = TRUE) || stop("Expected error message containing: ", containing, "\nActual error message: ", x[["message"]]))
# ------------------------------------------------------------------------------

test_library("nanonext")
nng_version()

later <- requireNamespace("later", quietly = TRUE)
promises <- requireNamespace("promises", quietly = TRUE)

test_class("nanoObject", n <- nano("req", listen = "inproc://nanonext", autostart = FALSE))
test_class("nanoObject", n1 <- nano("rep", dial = "inproc://nanonext", autostart = FALSE))
test_true(is_nano(n))
test_class("nanoSocket", n$socket)
test_class("nano", n$socket)
n$newmethod <- "doesnotwork"
test_null(n$newmethod)
test_type("integer", attr(n$socket, "id"))
test_equal(n$socket$state, "opened")
test_equal(n$socket$protocol, "req")
test_equal(n$send("not ready", mode = "serial"), 8L)
test_equal(n$recv(), 11L)
test_class("nano", n$opt("recv-size-max", 8192))
test_equal(n$opt("recv-size-max"), 8192L)
test_class("nano", n$opt("recv-buffer", 8L))
test_class("nano", n$opt("req:resend-time", 0L))
test_class("nano", n$opt("socket-name", "nano"))
test_equal(n$opt("socket-name"), "nano")
test_error(n$opt("socket-name", NULL), "argument")
test_print(n$listener[[1]])
test_class("nanoListener", n$listener[[1]])
test_equal(n$listener[[1]]$url, "inproc://nanonext")
test_equal(n$listener[[1]]$state, "not started")
test_class("nano", n$listener_opt("recv-size-max", 1024)[[1L]])
test_equal(n$listener_opt("recv-size-max")[[1L]], 1024L)
test_error(n$listener_opt("false", 100), "supported")
test_error(n$listener_opt("false"), "supported")
test_error(n$listener_opt("false", "false"), "supported")
test_error(n$listener_opt("false", NULL), "supported")
test_error(n$listener_opt("false", TRUE), "supported")
test_error(n$listener_opt("false", list()), "type")
test_zero(n$listener_start())
test_equal(n$listener[[1]]$state, "started")
test_print(n1$dialer[[1]])
test_class("nanoDialer", n1$dialer[[1]])
test_equal(n1$dialer[[1]]$url, "inproc://nanonext")
test_equal(n1$dialer[[1]]$state, "not started")
test_class("nano", n1$dialer_opt("reconnect-time-min", 1000)[[1L]])
test_equal(n1$dialer_opt("reconnect-time-min")[[1L]], 1000L)
test_class("nano", n1$dialer_opt("recv-size-max", 8192)[[1L]])
test_equal(n1$dialer_opt("recv-size-max")[[1L]], 8192L)
test_error(n1$dialer_opt("false", 100), "supported")
test_error(n1$dialer_opt("false"), "supported")
test_error(n1$dialer_opt("false", "false"), "supported")
test_error(n1$dialer_opt("false", NULL), "supported")
test_error(n1$dialer_opt("false", TRUE), "supported")
test_error(n1$dialer_opt("false", list()), "type")
test_zero(n1$dialer_start())
test_equal(n1$dialer[[1]]$state, "started")

test_error(n$send(list(), mode = "raw"), "atomic vector type")
test_error(n$recv(mode = "none"), "mode")
test_error(n$recv(mode = "int"), "mode")
test_error(n$recv(mode = "logica"), "mode")
test_error(n$recv(mode = "charact"), "mode")
test_error(n$recv(mode = "positrons"), "mode")
test_true(is_aio(raio <- n1$recv_aio(timeout = 1L)))
test_print(raio)
test_class("errorValue", call_aio(raio)$data)
test_class("errorValue", raio$data)
test_zero(pipe_id(raio))
r <- n$send(data.frame(), block = FALSE)
if (r == 8L) r <- n$send(data.frame(), block = 500L)
test_zero(r)
r <- n1$recv(block = FALSE)
if (is_error_value(r)) r <- n1$recv(block = 500)
test_class("data.frame", r)
test_zero(n1$send(c("test", "", "spec"), mode = "raw", block = 500))
test_identical(n$recv("character", block = 500), c("test", "", "spec"))
test_zero(n$send(1:5, mode = "raw"))
test_equal(length(n1$recv("integer", block = 500)), 5L)
test_true(is_aio(saio <- n1$send_aio(paste(replicate(5, random(1e3L)), collapse = ""), mode = 1L, timeout = 900)))
test_print(saio)
if (later) test_null(.keep(saio, new.env()))
test_class("sendAio", call_aio(saio))
test_zero(saio$result)
test_error(n$send("wrong mode", mode = "none"), "mode")
test_error(n$send("wrong mode", mode = "ser"), "mode")
test_error(n$send("wrong mode", mode = "rawial"), "mode")
test_class("recvAio", raio <- n$recv_aio(timeout = 500))
test_print(raio)
test_equal(nchar(call_aio(raio)[["value"]]), 10000L)
test_type("integer", pipe_id(raio))
raio$newfield <- "doesnotwork"
test_null(raio$newfield)
test_class("sendAio", saio <- n$send_aio(c(1.1, 2.2), mode = "raw", timeout = 500))
saio$newfield <- "doesnotwork"
test_null(saio$newfield)
test_type("logical", unresolved(saio))
test_type("logical", .unresolved(saio))
test_class("recvAio", msg <- n1$recv_aio(mode = "numeric", timeout = 500))
test_identical(call_aio(msg), msg)
test_class("recvAio", msg <- n1$recv_aio(mode = "complex", timeout = 500))
test_null(stop_aio(msg))
test_null(stop_aio(n))
test_identical(call_aio(msg), msg)
test_class("errorValue", msg$data)
test_identical(call_aio(n), n)
test_class("sendAio", sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = 1L, timeout = 500))
test_true(is_nul_byte(suppressWarnings(call_aio_(rraio)$data)))
test_class("sendAio", sraio <- n$send_aio(as.raw(1L), mode = 2L, timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "raw", timeout = 500))
test_type("raw", call_aio(rraio)$data)
test_class("sendAio", sraio <- n$send_aio(c(1+2i, 4+3i), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "complex", timeout = 500))
test_type("complex", call_aio(rraio)$data)
test_class("sendAio", sraio <- n$send_aio(5, mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "double", timeout = 500))
test_type("double", call_aio(rraio)$data)
test_class("sendAio", sraio <- n$send_aio(c(1, 2), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "numeric", timeout = 500))
test_true(is.numeric(call_aio(rraio)$data))
test_class("sendAio", sraio <- n$send_aio(c(1L, 2L, 3L), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "integer", timeout = 500))
test_type("integer", call_aio(rraio)$data)
test_class("sendAio", sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "double", timeout = 500))
test_type("raw", suppressWarnings(call_aio(rraio)$data))
test_class("sendAio", sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "integer", timeout = 500))
test_type("raw", suppressWarnings(call_aio(rraio)$data))
test_class("sendAio", sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "logical", timeout = 500))
test_type("raw", suppressWarnings(collect_aio(rraio)))
test_class("sendAio", sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "numeric", timeout = 500))
test_type("raw", suppressWarnings(rraio[]))
test_class("sendAio", sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
test_class("recvAio", rraio <- n1$recv_aio(mode = "complex", timeout = 500))
test_type("raw", suppressWarnings(collect_aio_(rraio)))
test_error(opt(rraio[["aio"]], "false") <- 0L, "valid")
test_error(subscribe(rraio[["aio"]], "false"), "valid")
test_error(opt(rraio[["aio"]], "false"), "valid")
test_error(stat(rraio[["aio"]], "pipes"), "valid")

test_zero(n$dial(url = "inproc://two", autostart = FALSE))
test_zero(n$dialer_start())
test_class("nanoDialer", n$dialer[[1L]])
test_type("double", stat(n$dialer[[1L]], "id"))
test_zero(n$listen(url = "inproc://three", autostart = FALSE))
test_zero(n$listener_start())
test_class("nanoListener", n$listener[[2L]])
test_type("double", stat(n$listener[[2L]], "id"))
test_zero(n$dial(url = "inproc://four"))
test_zero(close(n$listener[[1]]))
test_equal(suppressWarnings(start(n$listener[[1]])), 12L)
test_equal(suppressWarnings(close(n$listener[[1]])), 12L)
test_zero(close(n1$dialer[[1]]))
test_equal(suppressWarnings(start(n1$dialer[[1]])), 12L)
test_equal(suppressWarnings(close(n1$dialer[[1]])), 12L)
test_zero(reap(n$listener[[2]]))
test_zero(reap(n$dialer[[2]]))
test_zero(n$close())
test_zero(n1$close())
test_equal(suppressWarnings(n1$close()), 7L)
test_equal(n$socket[["state"]], "closed")
test_equal(n1$socket[state], "closed")

test_class("conditionVariable", cv <- cv())
test_print(cv)
test_true(!until(cv, 10L))
test_true(!until(cv, 10))
test_true(!until_(cv, 10L))
test_true(!until_(cv, 10))
test_true(!until_(cv, "test"))
test_zero(cv_reset(cv))
test_zero(cv_value(cv))

test_class("nanoObject", req <- nano("req", listen = "inproc://testing"))
test_class("nanoSocket", rep <- socket("rep", dial = "inproc://testing", listen = "inproc://testing2"))
test_print(rep)
test_equal(stat(rep, "dialers"), 1)
test_equal(stat(rep, "protocol"), "rep")
test_null(stat(rep, "nonexistentstat"))
test_class("nano", req$opt("req:resend-time", 1000))
test_equal(req$opt("req:resend-time"), 1000L)
test_error(req$opt("none"), "supported")
test_type("externalptr", req$context_open())
test_class("nanoContext", req$context)
test_class("nano", req$context)
test_type("integer", req$context$id)
test_equal(req$context$state, "opened")
test_equal(req$context$protocol, "req")
test_class("nano", req$opt("send-timeout", 1000))
test_equal(req$opt("send-timeout"), 1000L)
test_error(req$opt("false", 100), "supported")
test_error(req$opt("false"), "supported")
test_error(req$opt("false", "false"), "supported")
test_error(req$opt("false", NULL), "supported")
test_error(req$opt("false", TRUE), "supported")
test_error(req$opt("false", list()), "type")

test_class("nanoContext", ctx <- context(rep))
test_print(ctx)
test_equal(.header(12345L), 12345L)
test_true(.mark())
test_class("sendAio", csaio <- req$send_aio(data.frame(), mode = 1L, timeout = 500))
test_zero(call_aio_(csaio)$result)
test_class("recvAio", craio <- recv_aio(ctx, mode = 8L, timeout = 500))
test_type("raw", res <- collect_aio(craio))
test_true(.read_marker(res))
test_true(!.read_marker("not"))
test_equal(.read_header(res), 12345L)
test_equal(.read_header("not"), 0L)
test_type("list", unserialize(res[9:length(res)]))
test_equal(.header(0L), 0L)
test_true(!.mark(FALSE))
test_zero(req$send("context test", mode ="raw", block = 500))
test_equal(recv(ctx, mode = "string", block = 500), "context test")
test_type("integer", req$send(data.frame(), mode = "serial", block = 500))
test_class("recvAio", msg <- recv_aio(ctx, mode = "serial", timeout = 500))
test_type("logical", .unresolved(msg))
test_type("logical", unresolved(msg))
test_class("data.frame", call_aio(msg)$data)
test_true(!unresolved(msg))
test_equal(.header(2025250L), 2025250L)
test_zero(req$send(c(TRUE, FALSE, TRUE), mode = 2L, block = 500))
test_class("recvAio", msg <- recv_aio(ctx, mode = 6L, timeout = 500))
test_type("logical", msg[])
test_identical(collect_aio(msg), collect_aio_(msg))
test_class("sendAio", err <- send_aio(ctx, msg[["data"]], mode = "serial"))
test_null(stop_aio(err))
test_class("sendAio", err <- send_aio(ctx, "test"))
test_class("errorValue", call_aio(err)$result)
test_class("errorValue", call_aio(list(err))[[1L]][["result"]])
test_class("errorValue", call_aio_(err)$result)
test_class("errorValue", call_aio_(list(item = err))[["item"]][["result"]])
test_class("errorValue", collect_aio(err))
test_class("errorValue", collect_aio(list(item = err))[["item"]])
test_class("errorValue", collect_aio_(list(err))[[1L]])
test_zero(req$send(serialize(NULL, NULL, ascii = TRUE), mode = 2L, block = 500))
test_null(call_aio(recv_aio(ctx, mode = 1L, timeout = 500))[["value"]])
test_class("sendAio", saio <- send_aio(ctx, as.raw(1L), mode = 2L, timeout = 500))
test_identical(req$recv(mode = 8L, block = 500), as.raw(1L))
test_class("recvAio", rek <- request(req$context, c(1+3i, 4+2i), send_mode = 2L, recv_mode = "complex", timeout = 500))
test_zero(reply(ctx, execute = identity, recv_mode = 3L, send_mode = "raw", timeout = 500))
test_type("complex", call_aio(rek)[["data"]])
test_class("recvAio", rek <- request(req$context, c(1+3i, 4+2i), send_mode = "serial", recv_mode = "serial", timeout = 500))
test_zero(reply(ctx, execute = identity, recv_mode = 1L, send_mode = 1L, timeout = 500))
test_type("complex", call_aio(rek)[["data"]])
test_type("integer", rek[["aio"]])
test_equal(.header(0L), 0L)

test_type("list", cfg <- serial_config(class = c("invalid", "custom"), sfunc = list(identity, function(x) raw(1L)), ufunc = list(identity, as.integer)))
opt(req$socket, "serial") <- cfg
opt(rep, "serial") <- cfg
custom <- list(`class<-`(new.env(), "custom"), new.env())
test_zero(send(req$socket, custom, mode = "serial", block = 500))
test_type("integer", recv(rep, block = 500)[[1L]])
custom <- list(`class<-`(new.env(), "unused"), new.env())
test_zero(send(req$socket, custom, mode = "serial", block = 500))
test_type("list", recv(rep, block = 500))
cfg <- serial_config("custom", function(x) as.raw(length(x)), function(x) lapply(seq_len(as.integer(x)), new.env))
test_type("list", cfg)
opt(req$socket, "serial") <- cfg
opt(rep, "serial") <- cfg
test_zero(send(rep, custom, block = 500))
test_type("list", recv(req$socket, mode = 1L, block = 500))
opt(req$socket, "serial") <- list()
opt(rep, "serial") <- list()
test_error(serial_config(1L, identity, identity), "must be a character vector")
test_error(serial_config(c("custom", "custom2"), list(identity), list(identity)), "must all be the same length")
test_error(serial_config("custom", "func1", "func2"), "must be a function or list of functions")
test_error(serial_config("custom", identity, "func2"), "must be a function or list of functions")
test_error(opt(rep, "wrong") <- cfg, "not supported")
test_error(opt(rep, "serial") <- pairlist(a = 1L), "not supported")

test_class("recvAio", cs <- request(req$context, "test", send_mode = "serial", cv = cv, timeout = 500))
test_notnull(cs$data)
test_type("externalptr", ctxn <- .context(rep))
test_class("recvAio", cr <- recv_aio(ctxn, cv = cv, timeout = 500))
test_equal(call_aio(cr)$data, "test")
test_type("integer", cr$aio)
test_type("integer", send(ctxn, TRUE, mode = 0L, block = FALSE))
test_type("externalptr", ctxn <- .context(rep))
test_class("recvAio", cs <- request(.context(req$socket), data = TRUE, cv = NA))
test_notnull(cs$data)
test_true(recv(ctxn, block = 500))
test_zero(send(ctxn, TRUE, mode = 1L, block = 500))
test_class("recvAio", cs <- request(.context(req$socket), data = TRUE, timeout = 5, id = 12L))
test_zero(reap(ctxn))
test_equal(reap(ctxn), 7L)
test_zero(pipe_notify(rep, cv, add = TRUE, flag = TRUE))
test_zero(pipe_notify(rep, cv, remove = TRUE, flag = tools::SIGCONT))
test_zero(pipe_notify(req$socket, cv = cv, add = TRUE))
test_error(request(err, "test", cv = cv), "valid")
test_error(recv_aio(err, cv = cv, timeout = 500))
test_error(wait(err), "valid")
test_error(wait_(err), "valid")
test_error(until(err, 10), "valid")
test_error(until_(err, 10), "valid")
test_error(cv_value(err), "valid")
test_error(cv_reset(err), "valid")
test_error(cv_signal(err), "valid")
test_error(pipe_notify(err, cv), "valid Socket")
test_error(pipe_notify(rep, err), "valid Condition Variable")
test_zero(req$context_close())
test_null(req$context_close)
test_zero(req$close())
test_null(req$context)
rep$dialer <- NULL
test_type("externalptr", rep$dialer[[1L]])
test_zero(close(ctx))
test_equal(suppressWarnings(close(ctx)), 7L)
test_zero(close(rep))

test_class("nanoObject", pub <- nano("pub", listen = "inproc://ps"))
test_class("nanoObject", sub <- nano("sub", dial = "inproc://ps", autostart = NA))
test_zero(cv_reset(cv))
test_zero(pipe_notify(pub$socket, cv, add = TRUE, remove = TRUE))
test_class("nano", sub$opt(name = "sub:prefnew", value = FALSE))
test_true(!sub$opt(name = "sub:prefnew"))
test_error(sub$opt(name = "false", value = 100), "supported")
test_error(sub$opt(name = "false"), "supported")
test_error(sub$opt(name = "false", value = list()), "type")
test_class("nano", sub$subscribe("test"))
test_class("nano", subscribe(sub$socket, NULL))
test_class("nano", sub$unsubscribe("test"))
test_type("externalptr", sub$context_open())
test_class("nanoContext", sub$context)
test_class("nano", sub$subscribe(12))
test_class("nano", sub$unsubscribe(12))
test_class("nano", sub$subscribe(NULL))
test_zero(sub$context_close())
test_null(sub$context)
test_zero(sub$close())
test_zero(pub$close())
test_true(wait(cv))
test_type("externalptr", cv2 <- cv())
test_type("externalptr", cv3 <- cv())
test_type("externalptr", cv %~>% cv2 %~>% cv3)
test_zero(cv_signal(cv))
test_equal(cv_value(cv), 1L)
test_true(wait_(cv3))
test_type("externalptr", cv %~>% cv3)
test_error("a" %~>% cv3, "valid Condition Variable")
test_error(cv3 %~>% "a", "valid Condition Variable")

test_class("nanoObject", surv <- nano(protocol = "surveyor", listen = "inproc://sock1", dial = "inproc://sock2"))
test_print(surv)
test_class("nanoObject", resp <- nano(protocol = "respondent", listen = "inproc://sock2", dial = "inproc://sock1"))
test_zero(pipe_notify(surv$socket, cv, add = TRUE, remove = TRUE, flag = TRUE))
surv$dialer <- NULL
test_type("externalptr", surv$dialer[[1L]])
test_type("externalptr", surv$listener[[1L]])
test_class("nano", surv$survey_time(5000))
test_type("externalptr", surv$context_open())
test_type("externalptr", resp$context_open())
test_class("nano", surv$survey_time(value = 2000))
test_zero(surv$context_close())
test_zero(resp$context_close())
test_zero(surv$close())
test_zero(resp$close())
test_true(!wait(cv))
test_class("errorValue", resp$recv())

test_class("nanoObject", poly <- nano(protocol = "poly", listen = "inproc://polytest"))
test_equal(formals(poly$send)$pipe, 0L)
test_equal(formals(poly$send_aio)$pipe, 0L)
test_zero(poly$close())

test_zero(cv_reset(cv))
test_class("nanoSocket", poly <- socket(protocol = "poly"))
test_class("nanoSocket", poly1 <- socket(protocol = "poly"))
test_class("nanoSocket", poly2 <- socket(protocol = "poly"))
test_class("nanoMonitor", m <- monitor(poly, cv))
test_print(m)
test_zero(listen(poly))
test_null(read_monitor(m))
test_class("sendAio", send_aio(poly, "one", timeout = 50))
invisible(gc())
test_null(msleep(55))
test_zero(dial(poly1))
test_zero(dial(poly2))
test_true(wait(cv))
test_true(wait(cv))
test_equal(length(pipes <- read_monitor(m)), 2L)
test_zero(send_aio(poly, "one", timeout = 500, pipe = pipes[1L])[])
test_zero(send(poly, "two", block = 500, pipe = pipes[2L]))
test_type("integer", send(poly, "two", block = FALSE, pipe = pipes[2L]))
test_type("character", recv(poly1, block = 500))
test_type("character", recv(poly2, block = 500))
test_zero(reap(poly2))
test_zero(reap(poly1))
test_true(wait(cv))
test_type("integer", read_monitor(m))
test_error(read_monitor(poly), "valid Monitor")
test_error(monitor("socket", "cv"), "valid Socket")
test_error(monitor(poly, "cv"), "valid Condition Variable")
test_zero(reap(poly))

test_class("nanoSocket", bus <- socket(protocol = "bus"))
test_class("nanoSocket", push <- socket(protocol = "push"))
test_class("nanoSocket", pull <- socket(protocol = "pull"))
test_class("nanoSocket", pair <- socket(protocol = "pair"))
test_class("nano", bus)
test_equal(suppressWarnings(listen(bus, url = "test", fail = "warn")), 3L)
test_error(listen(bus, url = "test", fail = "error"), "argument")
test_equal(listen(bus, url = "test", fail = "none"), 3L)
test_equal(suppressWarnings(dial(bus, url = "test", fail = 1L)), 3L)
test_error(dial(bus, url = "test", fail = 2L), "argument")
test_equal(dial(bus, url = "test", fail = 3L), 3L)
test_error(listen(bus, url = "tls+tcp://localhost/:0", tls = "wrong"), "valid TLS")
test_error(dial(bus, url = "tls+tcp://localhost/:0", tls = "wrong"), "valid TLS")
test_zero(close(bus))
test_equal(suppressWarnings(close(bus)), 7L)
test_zero(close(push))
test_zero(close(pull))
test_zero(reap(pair))
test_error(socket(protocol = "newprotocol"), "protocol")
test_error(socket(dial = "test"), "argument")
test_error(socket(listen = "test"), "argument")

test_type("list", ncurl("http://www.cam.ac.uk/"))
test_type("list", ncurl("http://www.cam.ac.uk/", follow = FALSE, response = "date"))
test_type("list", ncurl("http://www.cam.ac.uk/", follow = TRUE))
test_type("list", ncurl("http://postman-echo.com/post", convert = FALSE, method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test", response = c("Date", "Server"), timeout = 3000))
test_class("errorValue", ncurl("http")$data)
test_class("recvAio", haio <- ncurl_aio("http://example.com/"))
test_true(is_aio(haio))
test_type("integer", call_aio(haio)$status)
test_class("ncurlAio", haio <- ncurl_aio("https://example.com/", convert = FALSE, response = "server"))
test_notnull(haio$status)
if (call_aio(haio)$status == 200L) test_notnull(haio$headers)
test_class("ncurlAio", put1 <- ncurl_aio("http://postman-echo.com/put", method = "PUT", headers = c(Authorization = "Bearer token"), data = "test", response = c("Date", "server"), timeout = 3000L))
test_print(put1)
test_type("integer", call_aio_(put1)$status)
if (put1$status == 200L) test_notnull(put1$headers)
if (put1$status == 200L) test_notnull(put1$data)
test_null(stop_aio(put1))
test_class("ncurlAio", haio <- ncurl_aio("https://i.i"))
test_class("errorValue", call_aio(haio)$data)
test_print(haio$data)
test_class("ncurlAio", ncaio <- ncurl_aio("https://nanonext.r-lib.org/reference/figures/logo.png"))
if (suppressWarnings(call_aio(ncaio)$status == 200L)) test_type("raw", ncaio$data)
test_class("errorValue", ncurl_aio("http")$data)
sess <- ncurl_session("https://postman-echo.com/post", method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test", response = c("date", "Server"), timeout = 3000L)
test_true(is_ncurl_session(sess) || is_error_value(sess))
if (is_ncurl_session(sess)) test_equal(length(transact(sess)), 3L)
if (is_ncurl_session(sess)) test_zero(close(sess))
if (is_ncurl_session(sess)) test_equal(suppressWarnings(close(sess)), 7L)
sess <- ncurl_session("https://postman-echo.com/post", convert = FALSE, method = "POST", headers = c(`Content-Type` = "text/plain"), timeout = 3000)
test_true(is_ncurl_session(sess) || is_error_value(sess))
if (is_ncurl_session(sess)) test_equal(length(transact(sess)), 3L)
if (is_ncurl_session(sess)) test_zero(close(sess))
if (is_ncurl_session(sess)) test_equal(transact(sess)$data, 7L)
test_class("errorValue", suppressWarnings(ncurl_session("https://i")))
test_error(ncurl_aio("https://", tls = "wrong"), "valid TLS")
test_error(ncurl("https://www.example.com/", tls = "wrong"), "valid TLS")
test_type("externalptr", etls <- tls_config())
test_error(stream(dial = "wss://127.0.0.1:5555", textframes = TRUE, tls = etls))
test_error(stream(dial = "wss://127.0.0.1:5555"))
test_error(stream(dial = "errorValue3"), "argument")
test_error(stream(dial = "inproc://notsup"), "Not supported")
test_error(stream(dial = "wss://127.0.0.1:5555", tls = "wrong"), "valid TLS")
test_error(stream(listen = "errorValue3"), "argument")
test_error(stream(listen = "inproc://notsup"), "Not supported")
test_error(stream(listen = "errorValue3", tls = "wrong"), "valid TLS")
test_error(stream(), "specify a URL")

test_type("character", ver <- nng_version())
test_equal(length(ver), 2L)
test_equal(nng_error(8L), "8 | Try again")
test_true(is_nul_byte(as.raw(0L)))
test_true(!is_nul_byte(NULL))
test_true(!is_error_value(1L))
test_error(messenger("invalidURL"), "argument")
test_type("raw", md5 <- nanonext:::md5_object("secret base"))
test_equal(length(md5), 32L)
test_type("double", mclock())
test_null(msleep(1L))
test_null(msleep(1))
test_null(msleep("a"))
test_type("character", urlp <- parse_url("://"))
test_equal(length(urlp), 10L)
test_true(all(nzchar(parse_url("wss://use:r@[::1]/path?q=1#name"))))
test_type("character", random())
test_equal(nchar(random(2)), 4L)
test_equal(length(random(4L, convert = FALSE)), 4L)
test_error(random(1025), "between 0 and 1024")
test_error(random(-1), "between 0 and 1024")
test_error(random("test"), "integer")
test_error(parse_url("tcp:/"), "argument")
for (i in c(100:103, 200:208, 226, 300:308, 400:426, 428:431, 451, 500:511, 600))
  test_type("character", status_code(i))

s <- tryCatch(stream(dial = "wss://echo.websocket.events/", textframes = TRUE), error = function(e) NULL)
if (is_nano(s)) test_notnull(recv(s, block = 500L))
if (is_nano(s)) test_type("character", opt(s, "ws:response-headers"))
if (is_nano(s)) test_error(opt(s, "ws:request-headers") <- "test\n", 24)
if (is_nano(s)) test_type("integer", send(s, c("message1", "test"), block = 500L))
if (is_nano(s)) test_notnull(recv(s, block = FALSE))
if (is_nano(s)) test_type("integer", send(s, "message2", block = FALSE))
if (is_nano(s)) test_notnull(suppressWarnings(recv(s, mode = 9L, block = 100)))
if (is_nano(s)) test_type("integer", send(s, 2L, block = 500))
if (is_nano(s)) test_class("recvAio", sr <- recv_aio(s, mode = "integer", timeout = 500L, n = 8192L))
if (is_nano(s)) test_notnull(suppressWarnings(call_aio(sr)[["data"]]))
if (is_nano(s)) test_null(stop_aio(sr))
if (is_nano(s)) test_class("sendAio", ss <- send_aio(s, "async", timeout = 500L))
if (is_nano(s)) test_type("integer", ss[])
if (is_nano(s)) test_null(stop_aio(ss))
if (is_nano(s)) test_type("integer", send(s, 12.56, mode = "raw", block = 500L))
if (is_nano(s)) test_class("recvAio", sr <- recv_aio(s, mode = "double", timeout = 500L, cv = cv))
if (is_nano(s)) test_notnull(suppressWarnings(call_aio_(sr)[["data"]]))
if (is_nano(s)) test_true(cv_value(cv) > 0L)
if (is_nano(s)) test_type("character", opt(s, "ws:request-headers"))
if (is_nano(s)) test_notnull(opt(s, "tcp-nodelay") <- FALSE)
if (is_nano(s)) test_error(opt(s, "none"), "supported")
if (is_nano(s)) test_error(`opt<-`(s, "none", list()), "supported")
if (is_nano(s)) test_print(s)
if (is_nano(s)) test_type("integer", close(s))

test_equal(nanonext:::.DollarNames.ncurlAio(NULL, "sta"), "status")
test_equal(nanonext:::.DollarNames.recvAio(NULL, "dat"), "data")
test_equal(nanonext:::.DollarNames.sendAio(NULL, "r"), "result")
test_zero(length(nanonext:::.DollarNames.nano(NULL)))

fakesock <- `class<-`(new.env(), "nanoSocket")
test_error(dial(fakesock), "valid Socket")
test_error(dial(fakesock, autostart = FALSE), "valid Socket")
test_error(listen(fakesock), "valid Socket")
test_error(listen(fakesock, autostart = FALSE), "valid Socket")
test_error(context(fakesock), "valid Socket")
test_error(.context(fakesock), "valid Socket")
test_error(stat(fakesock, "pipes"), "valid Socket")
test_error(close(fakesock), "valid Socket")
test_true(!.unresolved(fakesock))
fakectx <- `class<-`("test", "nanoContext")
test_true(!unresolved(fakectx))
test_true(!.unresolved(fakectx))
test_error(request(fakectx, data = "test"), "valid Context")
test_error(subscribe(fakectx, NULL), "valid")
test_error(close(fakectx), "valid Context")
test_equal(reap(fakectx), 3L)
fakestream <- `class<-`("test", "nanoStream")
test_print(fakestream)
fakesession <- `class<-`("test", "ncurlSession")
test_print(fakesession)
test_error(transact(fakesession), "valid")
test_error(close(fakesession), "valid")
test_error(send(fakestream, "test"), "valid")
test_error(send_aio(fakestream, "test"), "valid")
test_error(recv(fakestream), "valid")
test_error(recv_aio(fakestream), "valid")
test_error(opt(fakestream, name = "test") <- "test", "valid")
test_error(opt(fakestream, name = "test"), "valid")
test_error(close(fakestream), "valid Stream")
fakedial <- `class<-`("test", "nanoDialer")
test_error(start(fakedial), "valid Dialer")
test_error(close(fakedial), "valid Dialer")
fakelist <- `class<-`("test", "nanoListener")
test_error(start(fakelist), "valid Listener")
test_error(close(fakelist), "valid Listener")
unres <- `class<-`(NA, "unresolvedValue")
test_true(!unresolved(unres))
test_print(unres)
test_type("logical", unres <- unresolved(list("a", "b")))
test_equal(length(unres), 1L)
test_type("integer", unres <- .unresolved(list("a", "b")))
test_equal(length(unres), 1L)
test_identical(call_aio("a"), "a")
test_identical(call_aio_("a"), "a")
test_error(collect_aio_("a"), "object is not an Aio or list of Aios")
test_error(collect_aio_(list("a")), "object is not an Aio or list of Aios")
test_error(collect_aio(list(fakesock)), "object is not an Aio or list of Aios")
test_null(stop_aio("a"))
test_null(stop_aio(list("a")))
test_null(.keep(NULL, new.env()))
test_null(.keep(new.env(), new.env()))

pem <- "-----BEGIN CERTIFICATE----- -----END CERTIFICATE-----"
test_tls <- function(pem) {
  file <- tempfile()
  on.exit(unlink(file))
  cat(pem, file = file)
  test_error(tls_config(client = file), "Cryptographic error")
  test_error(tls_config(server = file), "Cryptographic error")
}
test_true(test_tls(pem = pem))
test_error(tls_config(client = c(pem, pem)), "Cryptographic error")
test_error(tls_config(server = c(pem, pem)), "Cryptographic error")
test_type("list", cert <- write_cert(cn = "127.0.0.1"))
test_equal(length(cert), 2L)
test_type("character", cert[[1L]])
test_identical(names(cert), c("server", "client"))
test_type("externalptr", tls <- tls_config(client = cert$client))
test_class("tlsConfig", tls)
test_print(tls)
test_class("errorValue", ncurl("https://www.example.com/", tls = tls)$status)
test_class("errorValue", call_aio(ncurl_aio("https://www.example.com/", tls = tls))$data)
test_error(ncurl_session("https://www.example.com/", tls = cert$client), "not a valid TLS")
sess <- ncurl_session("https://www.example.com/", tls = tls)
test_true(is_ncurl_session(sess) || is_error_value(sess))
if (is_ncurl_session(sess)) test_class("errorValue", transact(sess)[["headers"]])
test_type("externalptr", s <- socket(listen = "tls+tcp://127.0.0.1:5556", tls = tls_config(server = cert$server)))
test_type("externalptr", s1 <- socket(dial = "tls+tcp://127.0.0.1:5556", tls = tls))
test_true(suppressWarnings(dial(s, url = "tls+tcp://.", tls = tls)) > 0)
test_true(suppressWarnings(listen(s, url = "tls+tcp://.", tls = tls)) > 0)
test_zero(close(s1))
test_zero(close(s))
if (promises) test_class("nano", s <- socket(listen = "inproc://nanonext"))
if (promises) test_class("nano", s1 <- socket(dial = "inproc://nanonext"))
if (promises) test_class("recvAio", r <- recv_aio(s, timeout = 500L))
if (promises) test_true(promises::is.promise(promises::then(r, identity, identity)))
if (promises) test_type("integer", send(s1, "promises test\n", block = 500L))
if (promises) test_class("recvAio", r2 <- recv_aio(s, timeout = 1L))
if (promises) test_true(promises::is.promising(call_aio(r2)))
if (promises) test_true(promises::is.promise(promises::then(r2, identity, identity)))
if (promises) test_true(promises::is.promising(call_aio(r)))
if (promises) test_type("integer", send(s1, "promises test2\n", block = 500L))
if (promises) test_true(promises::is.promise(promises::then(call_aio(recv_aio(s, timeout = 500L)), identity, identity)))
if (promises) test_true(is_aio(n <- ncurl_aio("https://postman-echo.com/get")))
if (promises) test_true(promises::is.promise(promises::then(n, identity, identity)))
if (promises) test_true(promises::is.promising(call_aio(n)))
if (promises) test_true(promises::is.promise(promises::as.promise(call_aio(ncurl_aio("https://postman-echo.com/get")))))
if (promises) later::run_now(1L)
if (promises) test_zero(close(s1))
if (promises) test_zero(close(s))
if (promises) later::run_now(1L)
test_type("character", ip_addr())
test_type("character", names(ip_addr()))
test_null(write_stdout(""))
test_true(.interrupt())
test_true(!.interrupt(FALSE))
test_true(!identical(get0(".Random.seed"), {.advance(); .Random.seed}))
test_type("integer", .Call(nanonext:::rnng_traverse_precious))

if (!interactive() && Sys.getenv("NOT_CRAN") == "true") {
  test_class("conditionVariable", cv <- cv())
  f <- file("stdin", open = "r")
  test_true(is_nano(reader <- read_stdin()))
  test_zero(pipe_notify(reader, cv, remove = TRUE, flag = TRUE))
  test_true(is_aio(r <- recv_aio(reader, mode = "raw", cv = cv)))
  close(f)
  test_true(!wait(cv))
  test_zero(close(reader))
  test_equal(collect_aio(r), 7L)
}

if (Sys.info()[["sysname"]] == "Linux") {
  rm(list = ls())
  invisible(gc())
  .Call(nanonext:::rnng_fini_priors)
  Sys.sleep(1L)
  .Call(nanonext:::rnng_fini)
  invisible()
}
