% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socket.R
\name{collect_pipe}
\alias{collect_pipe}
\title{Collect the Pipe from an Aio}
\usage{
collect_pipe(x)
}
\arguments{
\item{x}{a 'recvAio' object.}
}
\value{
A Pipe (object of class \sQuote{nanoPipe}).
}
\description{
This function retrieves the Pipe used to receive a message from the Aio. It
    will block if the Aio has yet to complete. The message is still available
    for retrieval by the usual means. A Pipe is a low-level object and it is
    not normally necessary to deal with them directly.
}
\details{
As Pipes are always owned by a Socket, removing (and garbage
    collecting) a Pipe does not close it or free its resources. A Pipe may,
    however, be explicitly closed.
}
\examples{
s <- socket("rep", listen = "inproc://nanonext")
s1 <- socket("req", dial = "inproc://nanonext")

r <- recv_aio(s, timeout = 500)

if (!send(s1, "")) {
  p <- tryCatch(collect_pipe(r), error = identity)
  print(p)
  reap(p)
}

close(s)
close(s1)

}
