% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{recv_aio}
\alias{recv_aio}
\title{Receive Async}
\usage{
recv_aio(
  con,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw", "string"),
  timeout = NULL,
  cv = NULL,
  n = 65536L
)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{mode}{[default 'serial'] character value or integer equivalent - one of
\sQuote{serial} (1L), \sQuote{character} (2L), \sQuote{complex} (3L),
\sQuote{double} (4L), \sQuote{integer} (5L), \sQuote{logical} (6L),
\sQuote{numeric} (7L), \sQuote{raw} (8L), or \sQuote{string} (9L). The
default \sQuote{serial} means a serialised R object; for the other modes,
received bytes are converted into the respective mode. \sQuote{string} is
a faster option for length one character vectors. For Streams,
\sQuote{serial} is not an option and the default is \sQuote{character}.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout.}

\item{cv}{(optional) a \sQuote{conditionVariable} to signal when the async
receive is complete.}

\item{n}{[default 65536L] applicable to Streams only, the maximum number of
bytes to receive. Can be an over-estimate, but note that a buffer of this
size is reserved.}
}
\value{
A \sQuote{recvAio} (object of class \sQuote{recvAio}) (invisibly).
}
\description{
Receive data asynchronously over a connection (Socket, Context or Stream).
}
\details{
Async receive is always non-blocking and returns a \sQuote{recvAio}
    immediately.

    For a \sQuote{recvAio}, the received message is available at \code{$data}.
    An \sQuote{unresolved} logical NA is returned if the async operation is
    yet to complete.

    To wait for the async operation to complete and retrieve the received
    message, use \code{\link{call_aio}} on the returned \sQuote{recvAio}
    object.

    Alternatively, to stop the async operation, use \code{\link{stop_aio}}.

    In case of an error, an integer \sQuote{errorValue} is returned (to be
    distiguishable from an integer message value). This can be checked using
    \code{\link{is_error_value}}.

    If an error occurred in unserialization or conversion of the message data
    to the specified mode, a raw vector will be returned instead to allow
    recovery (accompanied by a warning).
}
\section{Signalling}{


    By supplying a \sQuote{conditionVariable}, when the receive is complete,
    the \sQuote{conditionVariable} is signalled by incrementing its value by
    1. This happens asynchronously and independently of the R execution
    thread.
}

\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

res <- send_aio(s1, data.frame(a = 1, b = 2), timeout = 100)
msg <- recv_aio(s2, timeout = 100)
msg
msg$data

res <- send_aio(s1, c(1.1, 2.2, 3.3), mode = "raw", timeout = 100)
msg <- recv_aio(s2, mode = "double", timeout = 100)
msg
msg$data

res <- send_aio(s1, "example message", mode = "raw", timeout = 100)
msg <- recv_aio(s2, mode = "character", timeout = 100)
call_aio(msg)
msg$data

close(s1)
close(s2)

# Signalling a condition variable

s1 <- socket("pair", listen = "tcp://127.0.0.1:6546")
cv <- cv()
msg <- recv_aio(s1, timeout = 100, cv = cv)
until(cv, 10L)
msg$data
close(s1)

# in another process in parallel
s2 <- socket("pair", dial = "tcp://127.0.0.1:6546")
res <- send_aio(s2, c(1.1, 2.2, 3.3), mode = "raw", timeout = 100)
close(s2)

}
