% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{call_aio}
\alias{call_aio}
\title{Call the Value of an Asynchronous AIO Operation}
\usage{
call_aio(aio)
}
\arguments{
\item{aio}{An Aio (object of class 'sendAio' or 'recvAio').}
}
\value{
The passed Aio object (invisibly).
}
\description{
Retrieve the value of an asynchronous AIO operation, waiting for the AIO
    operation to complete if still in progress.
}
\details{
For a 'recvAio', the received raw vector may be retrieved at \code{$raw}
    (unless 'keep.raw' was set to FALSE when receiving), and the converted R
    object at \code{$data}.

    For a 'sendAio', the send result may be retrieved at \code{$result}. This
    will be zero on success, or else an integer error code.

    To access the values directly, use for example on a 'recvAio' \code{x}:
    \code{call_aio(x)$data}.

    For a 'recvAio', in case of an error in unserialisation or data conversion
    (for example if the incorrect mode was specified), the received raw vector
    will be stored at \code{$data} to allow for the data to be recovered.

    Once the value has been successfully retrieved, the Aio is deallocated
    and only the value is stored in the Aio object.
}
\section{Alternatively}{


    Aio values may be accessed directly at \code{$result} for a 'sendAio',
    and \code{$raw} or \code{$data} for a 'recvAio'. If the Aio operation is
    yet to complete, an 'unresolved' logical NA will be returned. Once
    complete, the resolved value will be returned instead.

    \code{\link{unresolved}} may also be used, which returns TRUE only if an
    Aio or Aio value has yet to resolve and FALSE otherwise. This is suitable
    for use in control flow statements such as \code{while} or \code{if}.
}

\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

res <- send_aio(s1, data.frame(a = 1, b = 2), timeout = 100)
res
call_aio(res)
res$result

msg <- recv_aio(s2, timeout = 100)
msg
call_aio(msg)$data

close(s1)
close(s2)

}
