% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{send}
\alias{send}
\title{Send}
\usage{
send(con, data, mode = c("serial", "raw", "next"), block = NULL)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{data}{an object (a vector, if mode = 'raw').}

\item{mode}{[default 'serial'] one of 'serial' to send serialised R objects,
'raw' to send atomic vectors of any type as a raw byte vector, or 'next'
(see 'Send Modes' section below). Alternatively, specify an integer
position in the vector of choices e.g. 1L for 'serial' or 2L for 'raw'
etc. For Streams, 'raw' is the only option and this argument is ignored.}

\item{block}{[default NULL] which applies the connection default (see section
'Blocking' below). Specify logical TRUE to block until successful or
FALSE to return immediately even if unsuccessful (e.g. if no connection
is available), or else an integer value specifying the maximum time to
block in milliseconds, after which the operation will time out.}
}
\value{
Integer exit code (zero on success).
}
\description{
Send data over a connection (Socket, Context or Stream).
}
\section{Blocking}{


    For Sockets: the default behaviour is non-blocking with \code{block = FALSE}.
    This will return immediately with an error if the message could not be
    queued for sending. Certain protocol / transport combinations may limit
    the number of messages that can be queued if they have yet to be received.

    For Contexts: the default behaviour is blocking with \code{block = TRUE}.
    This will wait until the send has completed. Set to FALSE or an integer
    timeout to ensure that the function returns under all scenarios.

    For Streams: the default behaviour is blocking with \code{block = TRUE}.
    This will wait until the send has completed. Set a timeout to ensure that
    the function returns under all scenarios. As the underlying
    implementation uses an asynchronous send with a wait, it is recommended
    to set a positive integer value for \code{block} rather than FALSE.
}

\section{Send Modes}{


    The default mode 'serial' sends serialised R objects to ensure perfect
    reproducibility within R. When receiving, the corresponding mode 'serial'
    should be used.

    Mode 'raw' sends atomic vectors of any type as a raw byte vector, and
    must be used when interfacing with external applications or raw system
    sockets, where R serialization is not in use. When receiving, the mode
    corresponding to the vector sent should be used.

    Mode 'next' sends serialised R objects, with native extensions enabled by
    \code{\link{nextmode}}. This allows 'refhook' functions to be registered
    for custom serialization and unserialization of reference objects, such
    as those accessed via an external pointer. When receiving, mode 'serial'
    should be used as 'next' sends are fully compatible.
}

\examples{
pub <- socket("pub", dial = "inproc://nanonext")

send(pub, data.frame(a = 1, b = 2))
send(pub, c(10.1, 20.2, 30.3), mode = "raw", block = 100)

close(pub)

req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctx <- context(req)
send(ctx, data.frame(a = 1, b = 2), block = 100)

msg <- recv_aio(rep, timeout = 100)
send(ctx, c(1.1, 2.2, 3.3), mode = "raw", block = 100)

close(req)
close(rep)

}
\seealso{
\code{\link{send_aio}} for asynchronous send.
}
