% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-regions.R
\name{states}
\alias{states}
\alias{print.regions}
\alias{head.regions}
\alias{tail.regions}
\title{States of the Federal Republic of Nigeria}
\usage{
states(states, gpz = NULL, all = TRUE, warn = TRUE)

\method{print}{regions}(x, ...)

\method{head}{regions}(x, ...)

\method{tail}{regions}(x, ...)
}
\arguments{
\item{states}{One or more States of the Federation.}

\item{gpz}{Geopolitical zone. Default is \code{NULL}; optionally \code{"nc",
"ne", "nw", "se", "ss"} and \code{"sw"} (see "Details").}

\item{all}{logical; whether to include the Federal Capital Territory in 
the result.}

\item{warn}{logical; issue a warning when one or more elements are not
actually States (or were misspelt).}

\item{x}{The object of class \code{region}}

\item{...}{Arguments to \code{tail.default}}
}
\value{
The States of Nigeria as a whole or by zones, as an S3 object 
of class \code{states}.
}
\description{
States of the Federal Republic of Nigeria

Print regions

Return the First or Last Parts of a Region Object
}
\details{
gpz A geo-political zone, in the Nigerian 
context, is a national subdivision that groups contiguous states. 
Historically, they arise from subnational administrative divisions 
known as 'regions' that existed at the time of the country's independence.
There are 6 zones - North-Central, North-East, North-West, South-East,
South-South and South-West.
}
\examples{
states()  # lists names of all States
states(gpz = "se")  # lists States in South-East zone
}
