% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_format.R
\name{record_format}
\alias{record_format}
\alias{as.record_format}
\title{Define custom fields for NAACCR records}
\usage{
record_format(name, item, start_col, end_col, type, alignment = "left",
  padding = " ", name_literal = NULL)

as.record_format(x, ...)
}
\arguments{
\item{name}{Item name appropriate for a \code{data.frame} column name.}

\item{item}{NAACCR item number.}

\item{start_col}{First column of the field in a fixed-width record.}

\item{end_col}{Last column of the field in a fixed-width record.}

\item{type}{Name of the column class.}

\item{alignment}{Alignment of the field in fixed-width files. Either
\code{"left"} (default) or \code{"right"}.}

\item{padding}{Single-character strings to use for padding in fixed-width
files.}

\item{name_literal}{(Optional) Item name in plain language.}

\item{x}{Object to be coerced to a \code{record_format}, usually a
\code{data.frame} or \code{list}.}

\item{...}{Other arguments passed to \code{record_format}.}
}
\value{
An object of class \code{"record_format"} which has the following
  columns:
  \describe{
    \item{\code{name}}{
      (\code{character}) XML field name.
    }
    \item{\code{item}}{
      (\code{integer}) Field item number.
    }
    \item{\code{start_col}}{
      (\code{integer}) First column of the field in a fixed-width text file.
    }
    \item{\code{end_col}}{
      (\code{integer}) Last column of the field in a fixed-width text file.
    }
    \item{\code{type}}{
      (\code{factor}) R class for the column vector.
    }
    \item{\code{alignment}}{
      (\code{factor}) Alignment of the field's values in a fixed-width
      text file.
    }
    \item{\code{padding}}{
      (\code{character}) String used for padding field values in a
      fixed-width text file.
    }
    \item{\code{name_literal}}{
      (\code{character}) Field name in plain language.
    }
  }
}
\description{
Create a \code{record_format} object, which is used to read NAACCR records.
}
\details{
To define registry-specific fields in addition to the standard fields, create
a \code{record_format} object for the registry-specific fields and combine it
with one of the formats provided with the package using \code{rbind}.
}
\section{Format Types}{


  The levels \code{type} can take, along with the functions used to process
  them when reading a file:

  \describe{
    \item{\code{address}}{
      (\code{\link{clean_address_number_and_street}})
      Street number and street name parts of an address.
    }
    \item{\code{age}}{
      (\code{\link{clean_age}})
      Age in years.
    }
    \item{\code{boolean01}}{
      (\code{\link{naaccr_boolean}}, with \code{false_value = "0"})
      True/false, where \code{"0"} means false and \code{"1"} means true.
    }
    \item{\code{boolean12}}{
      (\code{\link{naaccr_boolean}}, with \code{false_value = "1"})
      True/false, where \code{"1"} means false and \code{"2"} means true.
    }
    \item{\code{census_block}}{
      (\code{\link{clean_census_block}})
      Census Block ID number.
    }
    \item{\code{census_tract}}{
      (\code{\link{clean_census_tract}})
      Census Tract ID number.
    }
    \item{\code{character}}{
      (\code{\link{clean_text}})
      Miscellaneous text.
    }
    \item{\code{city}}{
      (\code{\link{clean_address_city}})
      City name.
    }
    \item{\code{count}}{
      (\code{\link{clean_count}})
      Integer count.
    }
    \item{\code{county}}{
      (\code{\link{clean_county_fips}})
      County FIPS code.
    }
    \item{\code{Date}}{
      (\code{\link{as.Date}}, with \code{format = "\%Y\%m\%d"})
      NAACCR-formatted date (YYYYMMDD).
    }
    \item{\code{datetime}}{
      (\code{\link{as.POSIXct}}, with \code{format = "\%Y\%m\%d\%H\%M\%S"})
      NAACCR-formatted datetime (YYYYMMDDHHMMSS)
    }
    \item{\code{facility}}{
      (\code{\link{clean_facility_id}})
      Facility ID number.
    }
    \item{\code{icd_9}}{
      (\code{\link{clean_icd_9_cm}})
      ICD-9-CM code.
    }
    \item{\code{icd_code}}{
      (\code{\link{clean_icd_code}})
      ICD-9 or ICD-10 code.
    }
    \item{\code{integer}}{
      (\code{\link{as.integer}})
      Miscellaneous whole number.
    }
    \item{\code{numeric}}{
      (\code{\link{as.numeric}})
      Miscellaneous decimal number.
    }
    \item{\code{override}}{
      (\code{\link{naaccr_override}})
      Field describing why another field's value was over-ridden.
    }
    \item{\code{physician}}{
      (\code{\link{clean_physician_id}})
      Physician ID number.
    }
    \item{\code{postal}}{
      (\code{\link{clean_postal}})
      Postal code for an address (a.k.a. ZIP code in the United States).
    }
    \item{\code{ssn}}{
      (\code{\link{clean_ssn}})
      Social Security Number.
    }
    \item{\code{telephone}}{
      (\code{\link{clean_telephone}})
      10-digit telephone number.
    }
  }
}

\examples{
  my_fields <- record_format(
    name      = c("foo", "bar"),
    item      = c(2163, 1180),
    start_col = c(975, 1381),
    end_col   = c(975, 1435),
    type      = c("numeric", "facility")
  )
  my_format <- rbind(naaccr_format_16, my_fields)
}
