% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvLap.R
\name{InvLap}
\alias{InvLap}
\title{Inverse LST of a Node}
\usage{
InvLap(code, structure, outVar = "z", par = "value")
}
\arguments{
\item{code}{the genetic code (numeric vector) of the node (can be a leaf i.e. end by 0).}

\item{structure}{an object of class Mother (the structure).}

\item{outVar}{the output variable to be used ('z' by default).}

\item{par}{logical. Should the parameters be values ('value') or variables ('variable') ?}
}
\value{
A character string giving the inverse LST of the specified node.
}
\description{
With a specific path and a predefined structure
(S4 class of a type 'Mother'), returns the inverse Laplace-Stieltjes Transform expression of
the corresponding node with a specific variable.
}
\details{
For mother nodes, parameters are always called 'gamma' and for child nodes, parameters are
always called 'alpha'. Furthermore, to recognize the parameters, the path is inserted at the end.
For exemple, a child node with path (0,2,1) will have the parameter 'alpha021'.
}
\examples{

structure <- GEO(0.1, NULL, list(GAMMA(0.1, 1:2, NULL),
                           GAMMA(0.2, 3:4, NULL)))

InvLap(c(0,2), structure, outVar = 'z', par = 'value')

}
\seealso{
\link{Lap}
}
\author{
Simon-Pierre Gadoury
}
