% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzipmed_package.R
\name{mzip}
\alias{mzip}
\title{Marginalized Zero-Inflated Poisson Regression Model}
\usage{
mzip(y, pred, print = TRUE)
}
\arguments{
\item{y}{is the outcome variable}

\item{pred}{is a vector of covariates (use cbind for multiple)}

\item{print}{if =TRUE will give model parameters estimates and overall mean relative risks. Default =TRUE}
}
\value{
The function will return a list of 22 elements.
In the list G(Gamma) refers to the excess zero/logistic part of the model \cr
and A(Alpha) refers to the Poisson/mean part of the model for example. \cr
Gest are the gamma coefficients for the logistic part of the MZIP model. \cr
Aest are the alpha coefficients for the Poisson part of the MZIP model. \cr
_ModelSE are the standard errors for each coefficient in the model.\cr
_RobustSE are the robust standard errors for each coefficient in the model. \cr
_ModelUpper are the upper confidence limits for each coefficient. \cr
_ModelLower are the lower confidence limits. \cr
_RobustUpper are the upper confidence limits based on robust standard error. \cr
_RobustLower are the lower confidence limits based on robust standard errors. \cr
_ModelZ are the Z scores for each coefficient. \cr
_RobustZ are the robust Z scores for each coefficient. \cr
_ModelZpval are the p-values based on the Z scores for the model. \cr
_RobustZpval are the p-values based on the robust z scores. \cr
AlphaCov is the covariance matrix for the poisson coefficient estimates \cr
Cov is the covariance matrix for the MZIP model \cr
RobAlphaCov robust covariance matrix for the Poisson component of MZIP \cr
RobCov robust covariance matrix
}
\description{
This function uses the MZIP model to allow you to fit counts variables
with excess zeroes
while allowing for easy interpretations. This function assumes that
the outcome and covariates are all the same sample size without missing
data. Covariates must be numerical, so binary predictors such as
gender or race need to be dummy coded with zeroes and ones. For more
information about this model and interpretations see Long, D Leann et al. "A marginalized
zero-inflated Poisson regression model with overall exposure effects." Statistics in
medicine vol. 33,29 (2014): 5151-65. doi:10.1002/sim.6293.
Note: BFGS likelihood optimization was used for this R package
}
\examples{
    test=mzip(y=mzipmed_data$ziY1,pred=cbind(mzipmed_data$X,mzipmed_data$C1,
              mzipmed_data$C2),print=FALSE)

   \dontrun{
   test= mzip(y=mzipmed_data$ziY1,pred=cbind(X=mzipmed_data$X,C1=mzipmed_data$C1,
              C2=mzipmed_data$C2),print=TRUE)
              }
}
