% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_otsu_discordance_params.R
\name{validate_otsu_discordance_params}
\alias{validate_otsu_discordance_params}
\title{Internal function to validate parameters passed to \code{run_otsu_discordance}}
\usage{
validate_otsu_discordance_params(mx_data, table, threshold_override)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object used to compute Otsu discordance scores}

\item{table}{dataset in \code{mx_data} used to compute metrics. Options include: c("raw","normalized","both"), e.g. a y-axis parameter.}

\item{threshold_override}{optional user-defined function or alternate thresholding algorithm adaptable from Python skimage module \code{filters} (Note: not all algorithms in \code{filters} adapted). Options include supplying a function or any of the following: c("isodata", "li", "mean", "otsu", "triangle","yen"). More detail available here:https://scikit-image.org/docs/dev/api/skimage.filters.html. If using a user-defined function, it must include a \code{thold_data} parameter.}
}
\value{
\code{mx_dataset} object
}
\description{
Internal function to validate parameters passed to \code{run_otsu_discordance}
}
