\name{plot}
\alias{plot}
\alias{plot.mxspc}
\alias{plot.mxrpc}
\title{ Control Chart Plots for Maxwell-based V and VSQ Designs}
\description{Constructs control charts for Maxwell-based quality characteristics. This method supports objects of class \code{"mxrpc"} (for real-world data) and \code{"mxspc"} (for simulated data).}
\usage{
\method{plot}{mxrpc}(x, \dots)
\method{plot}{mxspc}(x, \dots)
}
\arguments{
  \item{x}{An object of class \code{"mxrpc"} or \code{"mxspc"} generated by a Maxwell charting function.}
  \item{\dots}{Additional graphical parameters passed to the underlying \code{plot} function.}
}

\details{
This is an S3 generic plot function with methods for objects of class \code{"mxrpc"} and \code{"mxspc"}.
}
\value{A control chart is drawn.}
\references{
Hossain, M.P., Omar, M.H. and Riaz, M. (2017) "New V control chart for the Maxwell distribution". Journal of Statistical Computation and Simulation, 87(3), pp.594-606. <doi:10.1080/00949655.2016.1222391>

Shah, F., Khan, Z., Aslam, M. and Kadry, S. (2021) "Statistical Development of the VSQ‐Control Chart for Extreme Data with an Application to the Carbon Fiber Industry". Mathematical Problems in Engineering, 2021(1), p.9766986. <doi:10.1155/2021/9766986>
}
\author{
Zahid Khan
}
\seealso{
\code{\link{mxspc}},\code{\link{mxrpc}}
}

\examples{
t1 <- mxspc(m = 30, n = 4, alpha = 0.0027, sigma = 1777.86,limit="PCL", chart = "V")
plot(t1)
}
