/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.ComponentSolver;

public class Postprocessor {
    private final int logLevel;
    private Graph g;
    private Signals s;
    private List<Unit> solution;

    public Postprocessor(Graph g, Signals s, List<Unit> sol, int logLevel) {
        this.solution = sol;
        this.s = s;
        this.g = g;
        this.logLevel = logLevel;
    }

    public List<Unit> minimize(double eps) throws SolverException {
        HashSet<Double> weights = new HashSet<Double>();
        HashSet<Integer> sets = new HashSet<Integer>();
        HashSet<Node> toRemove = new HashSet<Node>();
        for (Unit u : this.solution) {
            weights.add(this.s.weight(u));
            sets.addAll(this.s.unitSets(u));
        }
        for (Node r : this.g.vertexSet()) {
            if (sets.containsAll(this.s.unitSets((Unit)r))) continue;
            toRemove.add(r);
        }
        for (Node r : toRemove) {
            Set<Edge> es = this.g.edgesOf(r);
            for (Edge e : es) {
                this.s.remove(e);
            }
            this.g.removeVertex(r);
            this.s.remove(r);
        }
        this.s.addEdgePenalties(-eps / (double)this.g.edgeSet().size());
        ComponentSolver solver = new ComponentSolver(25, 0.0);
        solver.setPreprocessingLevel(0);
        solver.setThreadsNum(4);
        solver.setLogLevel(this.logLevel);
        List<Unit> res = solver.solve(this.g, this.s);
        return res;
    }
}

