% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_tests.R
\name{t_test_mverse}
\alias{t_test_mverse}
\title{Performs one or two sample t-tests on data columns.}
\usage{
t_test_mverse(
  .mverse,
  x = NULL,
  y = NULL,
  alternative = "two.sided",
  mu = 0,
  paired = FALSE,
  var.equal = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}

\item{x}{(optional) column name of data within mverse object}

\item{y}{(optional) column name of data within mverse object}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less". You can
specify just the initial letter.}

\item{mu}{a number indicating the true value of the mean (or difference
in means if you are performing a two sample test).}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two
variances as being equal.}

\item{conf.level}{confidence level of the interval.}
}
\value{
a multiverse table displaying the t-test results as a tibble.
}
\description{
\code{t_test_mverse} performs t-tests across the multiverse.
If x or y is specified, then performs one and two sample t-tests
on specified columns of the data. If both x and y are NULL, then
performs t.test based on the formula branches.
}
\examples{
# Performing a unpaired two sample t-test.
library(dplyr)
mv <- soccer \%>\%
  filter(!is.na(rater1), !is.na(rater2)) \%>\%
  mverse()
x <- mutate_branch(
  ((rater1 + rater2) / 2) > mean((rater1 + rater2) / 2),
  ifelse(rater1 > rater2, rater1 > 0.5, rater2 > 0.5)
)
y <- mutate_branch(
  redCards, yellowCards, yellowReds
)
two_sample_form <- formula_branch(y ~ x)
mv <- mv \%>\%
  add_mutate_branch(x, y) \%>\%
  add_formula_branch(two_sample_form)
t_test_mverse(mv)
}
