/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss;

import javax.swing.JOptionPane;
import org.af.commons.widgets.validate.ValidationException;
import org.af.jhlir.call.RObj;
import org.mutoss.Model;
import org.mutoss.MuTossControl;
import org.mutoss.gui.MuTossGUI;
import org.mutoss.gui.MuTossMainPanel;

public class MuTossObject {
    MuTossMainPanel mpanel;
    protected String objName;
    protected RObj muObj;
    protected Model model;

    public MuTossObject(String objName) {
        this.objName = objName;
        MuTossControl.getR().eval(objName + "<-new(\"Mutoss\")");
        this.muObj = MuTossControl.getR().eval(objName);
        this.mpanel = MuTossGUI.getGUI().getMpanel();
    }

    public void exportAs(String exportName) throws ValidationException {
        MuTossControl.getR().eval(exportName + " <- " + this.objName + "");
    }

    public RObj getAlpha() {
        return MuTossControl.getR().eval(this.objName + "@errorControl@alpha");
    }

    public RObj getData() {
        return MuTossControl.getR().eval(this.objName + "@data");
    }

    public RObj getHypotheses() {
        return MuTossControl.getR().eval(this.objName + "@hypotheses");
    }

    public Model getModel() {
        return this.model;
    }

    public MuTossMainPanel getMpanel() {
        return this.mpanel;
    }

    public RObj getMuObj() {
        return this.muObj;
    }

    public String getObjName() {
        return this.objName;
    }

    public RObj getPValues() {
        return MuTossControl.getR().eval(this.objName + "@pValues");
    }

    public boolean hasAdjPValues() {
        return MuTossControl.getR().eval("length(" + this.objName + "@adjPValues)!=0").asRLogical().getData()[0];
    }

    public boolean hasData() {
        return MuTossControl.getR().eval("length(" + this.objName + "@data)!=0").asRLogical().getData()[0];
    }

    public boolean hasErrorRate() {
        return MuTossControl.getR().eval("length(" + this.objName + "@errorControl@type)!=0").asRLogical().getData()[0];
    }

    public boolean hasModel() {
        return MuTossControl.getR().eval("!is.null(" + this.objName + "@model)").asRLogical().getData()[0];
    }

    public boolean hasP0() {
        return MuTossControl.getR().eval("length(" + this.objName + "@pi0)!=0").asRLogical().getData()[0];
    }

    public boolean hasPValues() {
        return MuTossControl.getR().eval("length(" + this.objName + "@pValues)!=0").asRLogical().getData()[0];
    }

    public boolean hasRejected() {
        return MuTossControl.getR().eval("length(" + this.objName + "@rejected)!=0").asRLogical().getData()[0];
    }

    public void setAdjPValues(RObj rObj, String label) {
        MuTossControl.getR().put(".MuTossAdjPValues", (Object)rObj);
        this.setAdjPValues(".MuTossAdjPValues", label);
    }

    private void setAdjPValues(String rName, String label) {
        if (MuTossControl.getR().eval("is.numeric(" + rName + ")").asRLogical().getData()[0]) {
            MuTossControl.getR().eval(this.objName + "@adjPValues <- " + rName + "");
            this.mpanel.mlAdjPValues.setText(label);
        } else {
            JOptionPane.showMessageDialog(MuTossGUI.getGUI(), "The adjusted p-values have to be of type numeric.", "No numeric", 0);
        }
    }

    public void setAlpha(String type, Double alpha) {
        MuTossControl.getR().eval(this.objName + "@errorControl <- new(Class=\"ErrorControl\", type=\"" + type + "\", alpha=" + alpha + ")");
        this.mpanel.mlErrorRate.setText(type + " (alpha=" + alpha + ")");
    }

    public void setConfIntervals(RObj ci, String label) {
        MuTossControl.getR().put(".MuTossTmpConfIntervals", (Object)ci);
        MuTossControl.getR().eval(this.objName + "@confIntervals <- .MuTossTmpConfIntervals");
        this.mpanel.mlCI.setText(label);
    }

    public void setData(String rName, String label) {
        MuTossControl.getR().eval(this.objName + "@data <- " + rName + "");
        MuTossControl.getR().eval(this.objName + "@description <- \"" + rName + "\"");
        this.mpanel.mlData.setText(label);
    }

    public void setHypotheses(RObj hypotheses) {
        MuTossControl.getR().put(".MuTossTmpHypotheses", (Object)hypotheses);
        MuTossControl.getR().eval(this.objName + "@hypotheses <- .MuTossTmpHypotheses");
        this.mpanel.mlHypotheses.setText("User defined matrix");
    }

    public void setModel(RObj model, String label) {
        MuTossControl.getR().put(".MuTossTmpModel", (Object)model);
        MuTossControl.getR().eval(this.objName + "@model <- .MuTossTmpModel");
        this.mpanel.mlModel.setText(label);
    }

    public void setModel(String rName) {
        MuTossControl.getR().eval(this.objName + "@model <- " + rName + "");
        this.model = new Model(rName);
        this.mpanel.mlModel.setText(new Model(rName).toString());
    }

    public void setPValues(RObj pValues, String label) {
        MuTossControl.getR().put(".MuTossTmpPValues", (Object)pValues);
        MuTossControl.getR().eval(this.objName + "@pValues <- .MuTossTmpPValues");
        this.mpanel.mlPValues.setText(label);
    }

    public void setPValues(String rName, String label) {
        if (MuTossControl.getR().eval("is.numeric(" + rName + ")").asRLogical().getData()[0]) {
            MuTossControl.getR().eval(this.objName + "@pValues <- " + rName + "");
            this.mpanel.mlPValues.setText(label);
        } else {
            JOptionPane.showMessageDialog(MuTossGUI.getGUI(), "The p-values have to be of type numeric.", "No numeric", 0);
        }
    }

    public void setRejected(RObj rObj, String label) {
        MuTossControl.getR().put(".MuTossRejected", (Object)rObj);
        this.setRejected(".MuTossRejected", label);
    }

    private void setRejected(String rName, String label) {
        if (MuTossControl.getR().eval("is.logical(" + rName + ")").asRLogical().getData()[0]) {
            MuTossControl.getR().eval(this.objName + "@rejected <- " + rName + "");
            this.mpanel.mlRejected.setText(label);
        } else {
            JOptionPane.showMessageDialog(MuTossGUI.getGUI(), "The rejected Hypotheses have to be of type logical.", "No logical", 0);
        }
    }

    public void setStringAsHypotheses(String hypotheses) {
        MuTossControl.getR().eval(this.objName + "@hypotheses <- \"" + hypotheses + "\"");
        this.mpanel.mlHypotheses.setText(hypotheses);
    }

    public RObj getRModel() {
        return MuTossControl.getR().eval(this.objName + "@model");
    }

    public Boolean hasCI() {
        return MuTossControl.getR().eval("length(" + this.objName + "@confIntervals)!=0").asRLogical().getData()[0];
    }

    public Object getErrorControlType() {
        return MuTossControl.getR().eval("" + this.objName + "@errorControl@type").asRChar().getData()[0];
    }

    public void setP0(RObj pi0, String label) {
        MuTossControl.getR().put(".MuTossTmpPi0", (Object)pi0);
        MuTossControl.getR().eval(this.objName + "@pi0 <- .MuTossTmpPi0");
        double estimate = MuTossControl.getR().eval(this.objName + "@pi0").asRNumeric().getData()[0];
        this.mpanel.mlP0.setText(label + ", Estimate: " + estimate);
    }

    public RObj getAdjPValues() {
        return MuTossControl.getR().eval(this.objName + "@adjPValues");
    }

    public void setErrorControl(RObj eC, String label) {
        String type = MuTossControl.getR().eval(this.objName + "@errorControl@type").asRChar().getData()[0];
        this.mpanel.mlErrorRate.setText(type + " ()");
    }
}

