/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnExt
extends TableColumn
implements Cloneable {
    protected boolean visible = true;
    protected Object prototypeValue;
    protected Comparator comparator;
    protected boolean sortable = true;
    protected boolean editable = true;
    private String toolTipText;
    protected Hashtable<Object, Object> clientProperties;
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;

    public TableColumnExt() {
        this(0);
    }

    public TableColumnExt(int modelIndex) {
        this(modelIndex, 75);
    }

    public TableColumnExt(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public TableColumnExt(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        super(modelIndex, width, cellRenderer, cellEditor);
    }

    private CompoundHighlighter getCompoundHighlighter() {
        return this.compoundHighlighter;
    }

    private void setCompoundHighlighter(CompoundHighlighter pipeline) {
        CompoundHighlighter old = this.getCompoundHighlighter();
        if (old != null) {
            old.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.compoundHighlighter = pipeline;
        if (this.compoundHighlighter != null) {
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", old, this.getCompoundHighlighter());
    }

    public void setHighlighters(Highlighter ... highlighters) {
        Contract.asNotNull(highlighters, "highlighters cannot be null or contain null");
        CompoundHighlighter pipeline = null;
        if (highlighters.length > 0) {
            pipeline = new CompoundHighlighter(highlighters);
        }
        this.setCompoundHighlighter(pipeline);
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter() != null ? this.getCompoundHighlighter().getHighlighters() : CompoundHighlighter.EMPTY_HIGHLIGHTERS;
    }

    public void addHighlighter(Highlighter highlighter) {
        CompoundHighlighter pipeline = this.getCompoundHighlighter();
        if (pipeline == null) {
            this.setCompoundHighlighter(new CompoundHighlighter(highlighter));
        } else {
            pipeline.addHighlighter(highlighter);
        }
    }

    public void removeHighlighter(Highlighter highlighter) {
        if (this.getCompoundHighlighter() == null) {
            return;
        }
        this.getCompoundHighlighter().removeHighlighter(highlighter);
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TableColumnExt.this.firePropertyChange("highlighters", null, TableColumnExt.this.getCompoundHighlighter());
            }
        };
    }

    @Override
    public boolean getResizable() {
        return super.getResizable() && this.getMinWidth() < this.getMaxWidth();
    }

    public void setEditable(boolean editable) {
        boolean oldEditable = this.editable;
        this.editable = editable;
        this.firePropertyChange("editable", oldEditable, editable);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setPrototypeValue(Object value) {
        Object oldPrototypeValue = this.prototypeValue;
        this.prototypeValue = value;
        this.firePropertyChange("prototypeValue", oldPrototypeValue, value);
    }

    public Object getPrototypeValue() {
        return this.prototypeValue;
    }

    public void setComparator(Comparator comparator) {
        Comparator old = this.getComparator();
        this.comparator = comparator;
        this.firePropertyChange("comparator", old, this.getComparator());
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setSortable(boolean sortable) {
        boolean old = this.isSortable();
        this.sortable = sortable;
        this.firePropertyChange("sortable", old, this.isSortable());
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setToolTipText(String toolTipText) {
        String old = this.getToolTipText();
        this.toolTipText = toolTipText;
        this.firePropertyChange("toolTipText", old, this.getToolTipText());
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setTitle(String title) {
        this.setHeaderValue(title);
    }

    public String getTitle() {
        Object header = this.getHeaderValue();
        return header != null ? header.toString() : null;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldVisible, visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null && this.getClientProperty(key) == null) {
            return;
        }
        Object old = this.getClientProperty(key);
        if (value == null) {
            this.getClientProperties().remove(key);
        } else {
            this.getClientProperties().put(key, value);
        }
        this.firePropertyChange(key.toString(), old, value);
    }

    public Object getClientProperty(Object key) {
        return key == null || this.clientProperties == null ? null : this.clientProperties.get(key);
    }

    private Hashtable<Object, Object> getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public Object clone() {
        TableColumnExt copy = new TableColumnExt(this.getModelIndex(), this.getWidth(), this.getCellRenderer(), this.getCellEditor());
        copy.setEditable(this.isEditable());
        copy.setHeaderValue(this.getHeaderValue());
        copy.setToolTipText(this.getToolTipText());
        copy.setIdentifier(this.getIdentifier());
        copy.setMaxWidth(this.getMaxWidth());
        copy.setMinWidth(this.getMinWidth());
        copy.setPreferredWidth(this.getPreferredWidth());
        copy.setPrototypeValue(this.getPrototypeValue());
        copy.setResizable(super.getResizable());
        copy.setVisible(this.isVisible());
        copy.setSortable(this.isSortable());
        copy.setComparator(this.getComparator());
        this.copyClientPropertiesTo(copy);
        if (this.compoundHighlighter != null) {
            copy.setHighlighters(this.getHighlighters());
        }
        return copy;
    }

    protected void copyClientPropertiesTo(TableColumnExt copy) {
        if (this.clientProperties == null) {
            return;
        }
        for (Object key : this.clientProperties.keySet()) {
            copy.putClientProperty(key, this.getClientProperty(key));
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeListener[] pcl;
        if ((oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) && (pcl = this.getPropertyChangeListeners()) != null && pcl.length != 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (int i = 0; i < pcl.length; ++i) {
                pcl[i].propertyChange(pce);
            }
        }
    }
}

