\name{seq_mnsl}
\alias{seq_mnsl}
\title{Generate a sequence of Munsell colours...}
\usage{seq_mnsl(from, to, n)}

\description{
  Generate a sequence of Munsell colours
}

\details{
  Generates a sequence of Munsell colours.  The sequence is
  generated by finding the closest munsell colours to a
  equidistant sequence of colours in #' LUV space.
}
\value{character vector of Munsell colours}
\arguments{
  \item{from}{character string of first Munsell colour}
  \item{to}{character string of last Munsell colour}
  \item{n}{number of colours in sequence}
}
\examples{seq_mnsl("5R 2/4", "5R 5/16", 4)
plot_mnsl(seq_mnsl("5R 2/4", "5R 5/16", 4))
plot_mnsl(seq_mnsl("5R 2/4", complement("5R 2/4", fix = TRUE), 5))}
