% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmggd.R
\name{dmggd}
\alias{dmggd}
\title{Density of a Multivariate Generalized Gaussian Distribution}
\usage{
dmggd(x, mu, Sigma, beta, tol = 1e-6)
}
\arguments{
\item{x}{length \eqn{p} numeric vector.}

\item{mu}{length \eqn{p} numeric vector. The mean vector.}

\item{Sigma}{symmetric, positive-definite square matrix of order \eqn{p}. The dispersion matrix.}

\item{beta}{positive real number. The shape of the distribution.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma.}
}
\value{
The value of the density.
}
\description{
Density of the multivariate (\eqn{p} variables) generalized Gaussian distribution (MGGD)
with mean vector \code{mu}, dispersion matrix \code{Sigma} and shape parameter \code{beta}.
}
\details{
The density function of a multivariate generalized Gaussian distribution is given by:
\deqn{ \displaystyle{ f(\mathbf{x}|\boldsymbol{\mu}, \Sigma, \beta) = \frac{\Gamma\left(\frac{p}{2}\right)}{\pi^\frac{p}{2} \Gamma\left(\frac{p}{2 \beta}\right) 2^\frac{p}{2\beta}} \frac{\beta}{|\Sigma|^\frac{1}{2}} e^{-\frac{1}{2}\left((\mathbf{x}-\boldsymbol{\mu})^T \Sigma^{-1} (\mathbf{x}-\boldsymbol{\mu})\right)^\beta} } }

When \eqn{p=1} (univariate case) it becomes:
\deqn{ \displaystyle{ f(x|\mu, \sigma, \beta) = \frac{\beta}{\Gamma\left(\frac{1}{2 \beta}\right) 2^\frac{1}{2 \beta} \sqrt{\sigma}} \ e^{\displaystyle{-\frac{1}{2} \left(\frac{(x - \mu)^2}{\sigma}\right)^\beta}} } }
}
\examples{
mu <- c(0, 1, 4)
Sigma <- matrix(c(0.8, 0.3, 0.2, 0.3, 0.2, 0.1, 0.2, 0.1, 0.2), nrow = 3)
beta <- 0.74
dmggd(c(0, 1, 4), mu, Sigma, beta)
dmggd(c(1, 2, 3), mu, Sigma, beta)

}
\references{
E. Gomez, M. Gomez-Villegas, H. Marin. A Multivariate Generalization of the Power Exponential Family of Distribution.
Commun. Statist. 1998, Theory Methods, col. 27, no. 23, p 589-600.
\doi{10.1080/03610929808832115}
}
\seealso{
\code{\link{rmggd}}: random generation from a MGGD.

\code{\link{estparmggd}}: estimation of the parameters of a MGGD.

\code{\link{plotmvd}}, \code{\link{contourmvd}}: plot of the probability density of a bivariate distribution.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
