% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{icecream}
\alias{icecream}
\title{Mixed factorial 2×2 design with polytomous response}
\format{
A data frame with 160 observations on the following 4 variables:
\describe{
\item{PId}{a subject identifier with levels \code{"1"} ... \code{"40"}}
\item{Age}{a between-subjects factor with levels \code{"adult"}, \code{"child"}}
\item{Season}{a within-subjects factor with levels \code{"fall"}, \code{"winter"}, \code{"spring"}, \code{"summer"}}
\item{Pref}{a polytomous response with categories \code{"vanilla"}, \code{"chocolate"}, \code{"strawberry"}}
}
}
\description{
This synthetic dataset represents a survey of 40 respondents about their favorite
ice cream flavor. Twenty of the respondents were adults and 20 were children. They
were queried four times over the course of a year, once in the middle of each season
(fall, winter, spring, summer).

This dataset has a polytomous response \code{Pref} and two factors,
\code{Age} and \code{Season}. The response has the unordered categories
\code{\{vanilla, chocolate, strawberry\}}. Factor \code{Age} has levels
\code{\{adult, child\}}, and factor \code{Season} has levels \code{\{fall, winter, spring, summer\}}.
It also has a \code{PId} column for participant identifier. Each participant identifier is repeated
four times, once per season.
}
\examples{
\donttest{
data(icecream, package="multpois")

icecream$PId = factor(icecream$PId)
icecream$Pref = factor(icecream$Pref, levels=c("vanilla","chocolate","strawberry"))
icecream$Age = factor(icecream$Age, levels=c("adult","child"))
icecream$Season = factor(icecream$Season, levels=c("fall","winter","spring","summer"))
contrasts(icecream$Age) <- "contr.sum"
contrasts(icecream$Season) <- "contr.sum"

m = glmer.mp(Pref ~ Age*Season + (1|PId), data=icecream)
Anova.mp(m, type=3)
glmer.mp.con(m, pairwise ~ Age*Season, adjust="holm")
}

}
\seealso{
See \code{vignette("multpois", package="multpois")} for a complete analysis of this data set.
}
\keyword{datasets}
