% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_version_management.R
\name{chooseVersion}
\alias{chooseVersion}
\title{Choose version based on the version indication, and available versions.}
\usage{
chooseVersion(
  packVersion,
  versionList,
  packageName = "",
  pick.last = FALSE,
  warn_for_major_diff = TRUE
)
}
\arguments{
\item{packVersion}{A single named version value. i.e. A package name and it's version requirement like: \code{c(dplyr = '>= 0.4.0')}.}

\item{versionList}{A list of available versions for this package to choose from. It is the list to choose from and check availability. Created with \code{lib.available_versions}.}

\item{packageName}{It is used for clear error handling. It should be the package name it is trying to load so we can mention it when crashing.}

\item{pick.last}{See details.}

\item{warn_for_major_diff}{If true, it will throw a warning when the requested package is a major release higher than that is specified.}
}
\description{
Obtains the correct version based on the version instruction provided (e.g. \code{>= 0.5}), the package name and it's available versions.
If no compatible version is found between the available versions a suitable error is thrown.
All different version indications should be handled in this function, including:
\enumerate{
  \item{a version with \code{>} or \code{>=} indicator.}
  \item{just a version e.g. \code{'0.5.0'} (most specific)}
  \item{a zero length char e.g. \code{''}}
}
}
\details{
Note that both (1) and (3) are effected by 'pick.last'.


If a version like \code{>= 0.5} is given and multiple versions exist, a choice needs to be made.
By default it will take the same or first higher version (when it exists, just \code{0.5} in the example).
This most likely leads to not changing the behaviour of the code. Alternatively, picking the latest version is most
likely to be accepted by other packages their dependencies (e.g. if a package that is loaded in the future depends on this package but asks for \code{> 0.6}, it will likely fail).
The downside of this is that an update could be a major one, going from \code{0.5} to \code{2.0}, where allot of things can have changed and your code that used to work fine is at risk.
}
