% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{bm_mpermute}
\alias{bm_mpermute}
\title{Extension of bigmemory::mpermute to allow decreasing parameter to be a vector}
\usage{
bm_mpermute(x, order = NULL, cols = NULL, allow.duplicates = FALSE,
  decreasing = FALSE, ...)
}
\arguments{
\item{x}{bigmemmory::big.matrix}

\item{order}{Ordering vector}

\item{cols}{Columns to sort on}

\item{allow.duplicates}{If TRUE allows row to be duplicated in result (order will be non-permutation of 1:nrow(x))}

\item{decreasing}{Sort in decreasing order: single value or equal to length of x for tie breaking}

\item{...}{Additional parameters to pass to \code{\link{bm_morder}}}
}
\value{
No return value: permutes in place
}
\description{
Extension of bigmemory::mpermute to allow decreasing parameter to be a vector
}
\examples{
\donttest{
bm <- bigmemory::big.matrix (9, 3)
bm[] <- sample(1:3, 27, replace=TRUE)
bm[]
bm_mpermute (bm, cols=1, decreasing=c(TRUE, FALSE))
bm_mpermute (bm, cols=1, decreasing=c(FALSE, TRUE))
}
}
\keyword{internal}

