% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_panel.R
\name{fill_panel}
\alias{fill_panel}
\alias{addPanel}
\alias{addpanel}
\alias{add_panel}
\title{fill_panel}
\usage{
fill_panel(figure, panel, row = "auto", column = "auto", label = NULL,
  label_just = c("right", "bottom"), panel_clip = c("on", "off", "inherit"),
  scaling = c("none", "stretch", "fit", "shrink"),
  allow_panel_overwriting = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{figure}{Object of classes \code{multipanelfigure}/
\code{\link[gtable]{gtable}} as produced by \code{\link{multi_panel_figure}}
and representing the figure the panel is to be placed in.}

\item{panel}{Single \code{\link{character}} object representing path to a
bitmap image (\code{*.png}, \code{*.tiff}/\code{*.tif},
\code{*.jpg}/\code{*.jpeg}), a \code{\link[ComplexHeatmap]{Heatmap}} or
\code{\link[ComplexHeatmap]{HeatmapList}} object, a
\code{\link[ggplot2]{ggplot}} object , a
\code{\link[lattice]{trellis.object}}, a \code{\link[grid]{gList}} object or
a \code{\link[grid]{grob}} object to be placed in a multipanel figure. See
'Details'.}

\item{row}{\code{\link{numeric}} object of length 1 or a range, indicating the row
indeces the panel that is to be placed in the figure, or "auto" to
automatically pick the row (see details). May be used to define  panel
spanning (if \code{length(row) > 1}; see examples).}

\item{column}{\code{\link{numeric}} object of length 1 or a range, indicating the
column indeces of the panel that is to be placed in the figure, or "auto" to
automatically pick the column (see details). May be used to define  panel
spanning (if \code{length(column) > 1}; see examples).}

\item{label}{Single \code{\link{character}} object defining the panel
label used for automated annotation.}

\item{label_just}{Justification for the label within the interpanel spacing
grob to the top-left of the panel content grob.  Passed to
\code{\link[grid]{textGrob}}.}

\item{panel_clip}{Should the display of panel contents be clipped at the
panel borders?  See \code{\link[grid]{viewport}}.}

\item{scaling}{Only used when importing image files. Either "none" to
preserve the dimensions of an image, "stretch" to make it fit the panels,
"fit" to shrink or enlarge it so that it fills one dimension of the panels
while preserving the height to width ratio, or "shrink which does the same
but won't enlarge it.}

\item{allow_panel_overwriting}{A logical value. If \code{TRUE}, overwriting
panels is allowed, with a warning.  Otherwise (the default) it will cause an
error.}

\item{verbose}{A logical value. Reduces verbosity if \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[utils]{download.file}}
when adding PNG, TIFF, or JPEG panels from URL. Also used to deal with
deprecated arguments \code{top_panel}, \code{bottom_panel}, \code{left_panel}
and \code{right_panel}.}
}
\value{
Returns the \code{\link[gtable]{gtable}} object fed to it
(\code{figure}) with the addition of the \code{panel}.
}
\description{
A convenience function adding graphical objects to a
\code{\link[gtable]{gtable}} constructed by \code{\link{multi_panel_figure}}.
}
\details{
Currently supported as panel-representing objects (\code{panel}) are
\enumerate{
  \item{ComplexHeatmap \code{\link[ComplexHeatmap]{Heatmap}} or
    \code{\link[ComplexHeatmap]{HeatmapList}} objects.}
  \item{ggplot2 \code{\link[ggplot2]{ggplot}} objects.}
  \item{grid \code{\link[grid]{grob}}, \code{\link[grid]{gList}}, and
    \code{\link[grid]{gTree}} objects.}
  \item{lattice \code{\link[lattice]{trellis.object}}s.}
  \item{Single \code{\link{character}} objects representing URLs or paths to
    readable portable network graphics (\code{*.png}), tagged image file
    format (\code{*.tiff}/\code{*.tif}), joint photographic experts group
    (\code{*.jpg}/\code{*.jpeg}) files, graphic interchange format
    (\code{*.gif}) or support vector graphics (\code{*.svg}) which will be
    read and placed into panels as requested.}}

For \code{*.tiff}/\code{*.tif} and \code{*.png} files, their native
resolution is determined from attributes in the file.  If the attributes are
not present, then the DPI is determined by the the
\code{multipanelfigure.defaultdpi} global option, or 300 if this has not been
set. \code{*.jpg}/\code{*.jpeg}, \code{*.gif} and \code{*.svg} images don't
support determining the resolution, so the resolution is always set to
\code{multipanelfigure.defaultdpi} or 300.

For animated GIFs, only the first frame will be used.

\pkg{lattice}-generated \code{\link[lattice]{trellis.object}}s are converted
to \code{grob}s using \code{grid.grabExpr(print(x))}, as are \code{Heatmap}
and \code{HeatmapList}s from \pkg{ComplexHeatmap} - the side effects of
which with respect to plot formatting are not well studied.

If the \code{row} argument is "auto", then the first row with
a free panel is used.
If the \code{column} argument is "auto", then the first column in the
row with a free panel is used.
}
\examples{
\donttest{ # Not testing - slow grid graphics makes CRAN timing excessive
# Create the figure layout
(figure <- multi_panel_figure(
  width = c(30,40,60),
  height = c(40,60,60,60),
  panel_label_type = "upper-roman"))

# Fill the top-left panel using a grob object directly
a_grob <- grid::linesGrob(arrow = grid::arrow())
figure \%<>\% fill_panel(a_grob)

# Add a ggplot object directly to the top row, second column.
# The panels are chosen automatically, but you can achieve the same effect
# using column = 2
a_ggplot <- ggplot2::ggplot(mtcars, ggplot2::aes(disp, mpg)) +
  ggplot2::geom_point()
figure \%<>\% fill_panel(a_ggplot)

# JPEG, PNG, TIFF, and SVG images are added by passing the path to their file.
image_files <- system.file("extdata", package = "multipanelfigure") \%>\%
  dir(full.names = TRUE) \%>\%
  setNames(basename(.))

# Add the JPEG to the top row, third column
figure \%<>\% fill_panel(image_files["rhino.jpg"], column = 3)

# Add the PNG to the second and third row, first and second column
figure \%<>\% fill_panel(
  image_files["Rlogo.png"],
  row = 2:3, column = 1:2)

# Add the TIFF to the second row, third column
figure \%<>\% fill_panel(
  image_files["unicorn.svg"],
  row = 2, column = 3)

# lattice/trellis plot objects are also added directly
Depth <- lattice::equal.count(quakes$depth, number=4, overlap=0.1)
a_lattice_plot <- lattice::xyplot(lat ~ long | Depth, data = quakes)
# Add the lattice plot to the third row, third column
figure \%<>\% fill_panel(
  a_lattice_plot,
  row = 3, column = 3)

# Incorporate a gList object (such as produced by VennDigram)
if(requireNamespace("VennDiagram"))
{
  a_venn_plot <- VennDiagram::draw.pairwise.venn(50, 30, 20, ind = FALSE)
  # Add the Venn diagram to the fourth row, firstd column
  figure \%<>\% fill_panel(
    a_venn_plot,
    row = 4, column = 1)
}

# Incorporate a base plot figure
a_base_plot <- capture_base_plot(
 heatmap(
   cor(USJudgeRatings), Rowv = FALSE, symm = TRUE, col = topo.colors(16),
   distfun = function(c) as.dist(1 - c), keep.dendro = TRUE,
   cexRow = 0.5, cexCol = 0.5))
# Add the heatmap to the fourth row, second column
figure \%<>\% fill_panel(
  a_base_plot,
  row = 4, column = 2)

# Incorporate a ComplexHeatmap figure
require(ComplexHeatmap)
mat = matrix(rnorm(80, 2), 8, 10)
mat = rbind(mat, matrix(rnorm(40, -2), 4, 10))
rownames(mat) = letters[1:12]
colnames(mat) = letters[1:10]
ht = Heatmap(mat)
a_complex_heatmap <- ht + ht + ht
# Add the ComplexHeatmap to the fourth row, third column
(figure \%<>\% fill_panel(
  a_complex_heatmap,
  row = 4, column = 3))
}
}
\seealso{
\code{\link[gtable]{gtable}}, \code{\link{multi_panel_figure}},
\code{\link[tiff]{readTIFF}}, \code{\link[png]{readPNG}},
\code{\link[jpeg]{readJPEG}}, \code{\link[caTools]{read.gif}},
\code{\link[rsvg]{rsvg}}
}
\author{
Johannes Graumann, Richard Cotton
}
