% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_multi_panel_figure.R
\name{save_multi_panel_figure}
\alias{save_multi_panel_figure}
\title{save_multi_panel_figure}
\usage{
save_multi_panel_figure(figure, filename, dpi = 300, ...)
}
\arguments{
\item{figure}{Object of classes \code{multipanelfigure}/
\code{\link[gtable]{gtable}} as produced by \code{\link{multi_panel_figure}}.}

\item{filename}{Single \code{\link{character}} object representing file
name/path to create on disk.}

\item{dpi}{Single \code{\link{numeric}} indicating the plot resolution.
Applies only to raster output types.}

\item{...}{Other arguments passed to \code{\link[ggplot2]{ggsave}}.}
}
\description{
A convenience function wrapping \code{\link[ggplot2]{ggsave}}
from \pkg{ggplot2} for easy saving of \code{\link[gtable]{gtable}} objects
constructed by \code{\link{multi_panel_figure}} taking into account the
table's dimensions.
}
\details{
Plot dimensions are determined using
\code{\link{figure_height}} and \code{\link{figure_width}}.

The Device type to use is guessed from the \code{filename} extension.
Currently supported are "eps", "ps", "tex" (pictex), "pdf", "jpeg", "tiff",
"png", "bmp", "svg" or "wmf" (windows only).
}
\examples{
# Create the figure layout
(figure <- multi_panel_figure(
  width = c(30,40,60),
  height = c(40,60,60,60),
  panel_label_type = "upper-roman"))

# Fill the top-left panel using a grob object directly
a_grob <- grid::linesGrob(arrow = grid::arrow())
figure \%<>\% fill_panel(a_grob)

\dontrun{
# Save the figure
figure \%>\%
  save_multi_panel_figure(
    filename = paste0(
    tempfile(),
    ".png"))
}
}
\seealso{
\code{\link[ggplot2]{ggsave}}, \code{\link{figure_width}},
\code{\link{figure_height}}
}
\author{
Johannes Graumann
}
