\name{predict_RF}
\alias{predict_RF}
\title{
Predict sample class based on gene pair-based random forest classifier
}
\description{
\code{predict_RF} predicts sample class based on pair-based random forest classifier
}
\usage{
predict_RF(classifier, Data)
}
\arguments{
  \item{classifier}{
classifier as a rule_based_RandomForest object, generated by train_RF function
}
  \item{Data}{
a matrix, dataframe, ExpressionSet, or data_object generated by ReadData function.
Samples as columns and row as features/genes.
}
}

\value{
returns predictions as "ranger.prediction" class
}

\author{
Nour-al-dain Marzouka <nour-al-dain.marzouka at med.lu.se>
}

\examples{
# generate random data
Data <- matrix(runif(10000), nrow=100, ncol=80,
               dimnames = list(paste0("G",1:100), paste0("S",1:80)))

# generate random labels
L <- sample(x = c("A","B","C","D"), size = 80, replace = TRUE)

# generate random platform labels
P <- sample(c("P1","P2","P3"), size = 80, replace = TRUE)

# create data object
object <- ReadData(Data = Data,
                   Labels = L,
                   Platform = P,
                   verbose = FALSE)

# sort genes
genes_RF <- sort_genes_RF(data_object = object,
                           seed=123456, verbose = FALSE)

# creat and sort rules
rules_RF <- sort_rules_RF(data_object = object,
                           sorted_genes_RF = genes_RF,
                           genes_altogether = 10,
                           genes_one_vs_rest = 10,
                           seed=123456, verbose = FALSE)

# train the final model
# it is prefered to increase the number of trees and rules in case you have
# large number of samples and features
# for quick example, we have small number of trees and rules here
RF_classifier <- train_RF(data_object = object,
                          rules_altogether = 10,
                          rules_one_vs_rest = 10,
                          run_boruta = FALSE,
                          plot_boruta = FALSE,
                          num.trees = 300,
                          sorted_rules_RF = rules_RF,
                          verbose = FALSE)

# predict
results <- predict_RF(classifier = RF_classifier,
                       Data = object)
results

# round(table(results$predictions, object$data$Labels))
}
