% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.LORgee.R
\name{vcov.LORgee}
\alias{vcov.LORgee}
\alias{vcov}
\title{Calculate Variance-Covariance Matrix for a Fitted LORgee Object.}
\usage{
\method{vcov}{LORgee}(object, method = "robust", ...)
}
\arguments{
\item{object}{a fitted model LORgee object.}

\item{method}{character indicating whether the sandwich (robust) covariance
matrix (\code{method = "robust"}) or the model--based (naive) covariance
matrix (\code{method = "naive"}) should be returned.}

\item{...}{additional argument(s) for methods.}
}
\value{
A matrix of the estimated covariances between the parameter estimates
in the linear predictor of the GEE model. This should have row and column
names corresponding to the parameter names given by the coef method.
}
\description{
Returns the variance-covariance matrix of the main parameters of a fitted
model LORgee object.
}
\details{
Default is to obtain the estimated sandwich (robust) covariance matrix and
\code{method = "naive"} obtains the estimated model-based (naive) covariance
matrix
}
\examples{
fitmod <- ordLORgee(formula = y ~ factor(time) + factor(trt) + factor(baseline),
  data = arthritis, id = id, repeated = time, LORstr = "uniform")
vcov(fitmod, method = "robust")
vcov(fitmod, method = "naive")

}
