% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernden.R
\name{kernden}
\alias{kernden}
\title{Calculate global bandwidth kernel estimates of density function}
\usage{
kernden(times, status, estgrid, bandwidth)
}
\arguments{
\item{times}{A vector of survival times. It does not need to be sorted.}

\item{status}{A vector indicating censoring: 0 - censored (alive), 1 - uncensored (dead).
If status is missing, all the observations are assumed uncensored.}

\item{estgrid}{A vector of time points at which the estimation will be made.}

\item{bandwidth}{Bandwidth used to determine the degree of smoothing.
Larger values of bandwidth will result in smoother of mean estimates.
It is suggested to start with a value of approximately 20\% of the range
of the survival times.}
}
\value{
Returns an object containing the time points of estimations (estgrid) and corresponding density estimates (denest).
}
\description{
Estimates global bandwidth kernel from right-censored data using the Epanechnikov kernel described in Silverman BW (1986).
}
\details{
Calculate global bandwidth kernel estimates of density function for survival times
}
\references{
Hess, K.R. and Zhong, M. Density Function Estimation for Possibly Right-Censored Data Using Kernel Functions. Submitted.
}
\author{
R. Herrick and Dan Serachitopol
}
