% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename_locations}
\alias{rename_locations}
\alias{rename_locations.default}
\alias{rename_params}
\alias{rename_params.default}
\alias{rename_datasets}
\alias{rename_datasets.default}
\alias{rename_columns}
\alias{rename_columns.default}
\title{Rename identifiers in a mudata object}
\usage{
rename_locations(.data, ...)

\method{rename_locations}{default}(.data, ...)

rename_params(.data, ...)

\method{rename_params}{default}(.data, ...)

rename_datasets(.data, ...)

\method{rename_datasets}{default}(.data, ...)

rename_columns(.data, ...)

\method{rename_columns}{default}(.data, ...)
}
\arguments{
\item{.data}{A mudata object}

\item{...}{Variables to rename in the form \code{new_var = old_var}}
}
\value{
A modified mudata object
}
\description{
These functions rename locations, datasets, params, and columns, making sure
internal consistency is maintained. These functions use dplyr syntax for renaming
(i.e. the \link[dplyr]{rename} function). This syntax can also be used while
subsetting using \link{select_locations} and family.
}
\examples{
rename_datasets(kentvillegreenwood, avalley = ecclimate)
rename_locations(kentvillegreenwood, Greenwood = starts_with("GREENWOOD"))
rename_params(kentvillegreenwood, max_temp = maxtemp)
rename_columns(kentvillegreenwood, lon = longitude, lat = latitude)

}
\seealso{
\link[dplyr]{rename}, \link{select_locations}
}
