% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp2long.R
\name{pp2long}
\alias{pp2long}
\title{Auxiliary function to transform data from paired-preference to
long-arm format}
\usage{
pp2long(x)
}
\arguments{
\item{x}{An object of class "ppdata" (part of \code{\link{tcc}} object).}
}
\value{
Data set in long-arm format that can be used as input to
\code{\link[PlackettLuce]{rankings}}.
}
\description{
Auxiliary function to transform data from paired-preference to
long-arm format
}
\examples{
data(diabetes)
#
ranks <- tcc(treat = t, studlab = study, event = r, n = n, data = diabetes,
  mcid = 1.20, sm = "OR", small.values = "desirable")
#
pdat <- ranks$ppdata
#
ldat <- pp2long(pdat)
head(ldat)

library("PlackettLuce")
ungrouped.preferences <-
  rankings(ldat, id = "id", item = "treat", rank = "rank")
grouped.preferences <-
  as.rankings(ungrouped.preferences,
              index = as.numeric(as.factor(pdat$studlab)))
#
fit <- PlackettLuce(grouped.preferences)
#
coef(summary(fit, ref = ranks$reference.group))[, 1]
# Results stored in mtrank()
mtrank(ranks)$estimates$log_ability

}
\seealso{
\code{\link{tcc}}, \code{\link[PlackettLuce]{rankings}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
