% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_html.R
\name{add_colored_str}
\alias{add_colored_str}
\title{Add a string with specified color or background color.}
\usage{
add_colored_str(
  text = "",
  color = c(51, 122, 183),
  alpha = 255,
  bgcolor = NULL,
  bgalpha = 51,
  fontsize = 1,
  bold = FALSE,
  it = FALSE
)
}
\arguments{
\item{text}{A string. default="".}

\item{color}{One of
\itemize{
  \item a color name, e.g. 'red'.
  \item a HEX color string, e.g. '#000000' or '#000000FF'.
  \item an RGB vector for the color of text
}}

\item{alpha}{An integer between 1 and 255 for text alpha. default=255.}

\item{bgcolor}{One of
\itemize{
  \item a color name, e.g. 'red'.
  \item a HEX color string, e.g. '#000000' or '#000000FF'.
  \item an RGB vector for the color of text
}}

\item{bgalpha}{An integer between 1 and 255 for background alpha. default=51.}

\item{fontsize}{A real number between 0.5 and 5.0 for font size. default=1.}

\item{bold}{A logical value for bold fonts. default=\code{FALSE}.}

\item{it}{A Boolean value for italic fonts. default=\code{FALSE}.}
}
\value{
a formatted string
}
\description{
\code{add_colored_str} returns a string component generated by \code{htmltools}
with specified color and styles.
}
\examples{
add_colored_str("warning: read this message carefully.", color = c(255, 0, 0))

}
