\name{Err.msgl}
\alias{Err.msgl}
\title{Compute error rates}
\usage{
  \method{Err}{msgl} (object, data = NULL,
    response = object$classes.true, classes = response,
    type = "rate", ...)
}
\arguments{
  \item{object}{a msgl object}

  \item{data}{a matrix of}

  \item{response}{a vector of classes}

  \item{classes}{a vector of classes}

  \item{type}{type of error rate \code{rate} or
  \code{count}}

  \item{...}{ignored}
}
\value{
  a vector of error rates
}
\description{
  Compute error rates. If \code{type = "rate"} then the
  misclassification rates will be computed. If \code{type =
  "count"} then the misclassification counts will be
  computed. If \code{type = "loglike"} then the negative
  log likelihood error will be computed.
}
\examples{
data(SimData)
x.all <- sim.data$x
x.1 <- sim.data$x[1:50,]
x.2 <- sim.data$x[51:100,]
classes.all <- sim.data$classes
classes.1 <- sim.data$classes[1:50]
classes.2 <- sim.data$classes[51:100]

#### Fit models using x.1
lambda <- msgl.lambda.seq(x.1, classes.1, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl(x.1, classes.1, alpha = .5, lambda = lambda)

#### Training errors:

# Misclassification rate
Err(fit, x.1)

# Misclassification count
Err(fit, x.1, type = "count")

# Negative log likelihood error
Err(fit, x.1, type="loglike")

# Misclassification rate of x.2
Err(fit, x.2, classes.2)

#### Do cross validation
fit.cv <- msgl.cv(x.all, classes.all, alpha = .5, lambda = lambda)

#### Cross validation errors (estimated expected generalization error)

# Misclassification rate
Err(fit.cv)

# Negative log likelihood error
Err(fit.cv, type="loglike")

#### Do subsampling
test <- list(1:20, 21:40)
train <- lapply(test, function(s) (1:length(classes.all))[-s])

fit.sub <- msgl.subsampling(x.all, classes.all, alpha = .5,
 lambda = lambda, training = train, test = test)

# Mean misclassification error of the tests
Err(fit.sub)

# Negative log likelihood error
Err(fit.sub, type="loglike")
}
\author{
  Martin Vincent
}

