% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_data_color.R
\name{chart_data_stroke}
\alias{chart_data_stroke}
\title{Modify marker stroke colour}
\usage{
chart_data_stroke(x, values)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{values}{\verb{character(num of series)}: a set of colours values to map data values to.
It is a named vector, the values will be matched based on the names.
If it contains only one colour, this colour will be associated to all existing series.}
}
\description{
Specify mappings from levels in the data to displayed marker stroke colours.
}
\examples{
my_scatter <- ms_scatterchart(data = iris, x = "Sepal.Length",
  y = "Sepal.Width",  group = "Species")
my_scatter <- chart_data_fill(my_scatter,
  values = c(virginica = "#6FA2FF", versicolor = "#FF6161", setosa = "#81FF5B") )
my_scatter <- chart_data_stroke(my_scatter,
  values = c(virginica = "black", versicolor = "black", setosa = "black") )
}
\seealso{
\code{\link{chart_data_fill}}, \code{\link{chart_data_symbol}}, \code{\link{chart_data_size}}
}
