% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msaenet.R
\name{msaenet}
\alias{msaenet}
\title{Multi-Step Adaptive Elastic-Net}
\usage{
msaenet(x, y, family = c("gaussian", "binomial", "poisson", "multinomial",
  "cox", "mgaussian"), init = c("enet", "ridge"), nsteps = 2L,
  nfolds = 5L, alphas = seq(0.05, 0.95, 0.05), gamma = 1,
  rule = c("lambda.min", "lambda.1se"), seed = 1001, parallel = FALSE,
  verbose = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response vector.}

\item{family}{Response type.}

\item{init}{Type of the penalty used in the initial
estimation step. Could be \code{"enet"} or \code{"ridge"}.
See \code{\link[glmnet]{glmnet}} for details.}

\item{nsteps}{How many adaptive estimation steps? At least 2.
We assume adaptive elastic-net has only 1 adaptive estimation step.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{alphas}{Vector of alphas to use in \code{\link[glmnet]{cv.glmnet}}.}

\item{gamma}{Scaling factor for adaptive weights:
\code{weights = coefs^(-gamma)}.}

\item{rule}{Model selection criterion, \code{"lambda.min"} or
\code{"lambda.1se"}. See \code{\link[glmnet]{cv.glmnet}} for details.}

\item{seed}{Two random seeds for cross-validation fold division
in two estimation steps.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is {FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}

\item{verbose}{Should we print out the progress?}
}
\value{
List of coefficients \code{beta} and
\code{glmnet} model object \code{model}.
}
\description{
Multi-Step Adaptive Elastic-Net
}
\examples{
dat = msaenet.sim.gaussian(n = 150, p = 500, rho = 0.6,
                           coef = rep(1, 5), snr = 2, p.train = 0.7,
                           seed = 1001)

msaenet.fit = msaenet(dat$x.tr, dat$y.tr,
                      alphas = seq(0.2, 0.8, 0.2),
                      nsteps = 3L, seed = 1003)

print(msaenet.fit)
msaenet.nzv(msaenet.fit)
msaenet.fp(msaenet.fit, 1:5)
msaenet.tp(msaenet.fit, 1:5)
msaenet.pred = predict(msaenet.fit, dat$x.te)
msaenet.rmse(dat$y.te, msaenet.pred)
plot(msaenet.fit)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\references{
Nan Xiao and Qing-Song Xu. (2015). Multi-step adaptive elastic-net:
reducing false positives in high-dimensional variable selection.
\emph{Journal of Statistical Computation and Simulation} 85(18), 3755--3765.
}

