% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir_byfutime.R
\name{sir_byfutime}
\alias{sir_byfutime}
\title{Calculate standardized incidence ratios with custom grouping variables stratified by follow-up time}
\usage{
sir_byfutime(
  df,
  dattype = "zfkd",
  ybreak_vars = "none",
  xbreak_var = "none",
  futime_breaks = c(0, 0.5, 1, 5, 10, Inf),
  count_var,
  refrates_df = rates,
  calc_total_row = TRUE,
  calc_total_fu = TRUE,
  region_var = NULL,
  age_var = NULL,
  sex_var = NULL,
  year_var = NULL,
  race_var = NULL,
  site_var = NULL,
  futime_var = NULL,
  alpha = 0.05
)
}
\arguments{
\item{df}{dataframe in wide format}

\item{dattype}{can be "zfkd" or "seer" or empty. Will set default variable names from dataset.}

\item{ybreak_vars}{variables from df by which SIRs should be stratified in result df. Multiple variables will result in
appended rows in result df.
Careful: do not chose any variables that are dependent on occurrence of count_var (e.g. Histology of second cancer).
If y_break_vars = "none", no stratification is performed. Default is "none".}

\item{xbreak_var}{One variable from df by which SIRs should be stratified as a second dimension in result df. This variable will be added as
a second stratification dimension to ybreak_vars and all variables will be calculated for subpopulations of x and y combinations.
Careful: do not chose any variables that are dependent on occurrence of count_var (e.g. Year of second cancer).
If y_break_vars = "none", no stratification is performed. Default is "none".}

\item{futime_breaks}{vector that indicates split points for follow-up time groups (in years) that will be used as xbreak_var.
Default is c(0, .5, 1, 5, 10, Inf) that will result in 5 groups (up to 6 months, 6-12 months, 1-5 years, 5-10 years, 10+ years).
If you don't want to split by follow-up time, use futime_breaks = "none".}

\item{count_var}{variable to be counted as observed case. Cases are usually the second cancers. Should be 1 for case to be counted.}

\item{refrates_df}{df where reference rate from general population are defined. It is assumed that refrates_df has the columns
"region" for region, "sex" for biological sex, "age" for age-groups (can be single ages or 5-year brackets), "year" for time period (can be single year or 5-year brackets),
"incidence_crude_rate" for incidence rate in the respective age/sex/year cohort.
refrates_df must use the same category coding of age, sex, region, year and t_site as age_var, sex_var, region_var, year_var and site_var.}

\item{calc_total_row}{option to calculate a row of totals. Can be either FALSE for not adding such a row or TRUE for adding it at the first row. Default is TRUE.}

\item{calc_total_fu}{option to calculate totals for follow-up time. Can be either FALSE for not adding such a column or TRUE for adding. Default is TRUE.}

\item{region_var}{variable in df that contains information on region where case was incident. Default is set if dattype is given.}

\item{age_var}{variable in df that contains information on age-group. Default is set if dattype is given.}

\item{sex_var}{variable in df that contains information on sex. Default is set if dattype is given.}

\item{year_var}{variable in df that contains information on year or year-period when case was incident. Default is set if dattype is given.}

\item{race_var}{optional argument for dattype="seer", if SIR should be calculated stratified by race. If you want to use this option, provide variable name of df that contains race information.}

\item{site_var}{variable in df that contains information on ICD code of case diagnosis. Cases are usually the second cancers. Default is set if dattype is given.}

\item{futime_var}{variable in df that contains follow-up time per person between date of first cancer and any of death, date of event (case), end of FU date (in years; whatever event comes first). Default is set if dattype is given.}

\item{alpha}{significance level for confidence interval calculations. Default is alpha = 0.05 which will give 95 percent confidence intervals.}
}
\description{
Calculate standardized incidence ratios with custom grouping variables stratified by follow-up time
}
\examples{
#There are various preparation steps required, before you can run this function.
#Please refer to the Introduction vignette to see how to prepare your data
\dontrun{
usdata_wide \%>\%
  sir_byfutime(
        dattype = "seer",
        ybreak_vars = c("race.1", "t_dco.1"),
        xbreak_var = "none",
        futime_breaks = c(0, 1/12, 2/12, 1, 5, 10, Inf),
        count_var = "count_spc",
        refrates_df = us_refrates_icd2,
        calc_total_row = TRUE,
        calc_total_fu = TRUE,
        region_var = "registry.1",
        age_var = "fc_agegroup.1",
        sex_var = "sex.1",
        year_var = "t_yeardiag.1",
        site_var = "t_site_icd.1", #using grouping by second cancer incidence
        futime_var = "p_futimeyrs",
        alpha = 0.05)
        }

}
