% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgindata.R
\name{valid_data}
\alias{valid_data}
\alias{valid_data_set}
\alias{valid_data_set.default}
\alias{valid_data_set.data.frame}
\alias{valid_idata_set}
\alias{valid_data_set.matrix}
\title{Validate and prepare data sets for simulation.}
\usage{
valid_data_set(x, ...)

\method{valid_data_set}{default}(x, ...)

\method{valid_data_set}{data.frame}(x, m = NULL, verbose = FALSE,
  quiet = FALSE, ...)

valid_idata_set(x, verbose = FALSE, quiet = FALSE, ...)

\method{valid_data_set}{matrix}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{data.frame or matrix}

\item{...}{additional arguments}

\item{m}{a model object}

\item{verbose}{logical}

\item{quiet}{if \code{TRUE}, messages will be suppressed}
}
\value{
a matrix with non-numeric columns dropped; if x is a 
data.frame with character \code{cmt} column comprised of valid 
compartment names and \code{m} is a model object,
the \code{cmt} column will be converted to the corresponding 
compartment number.

A numeric matrix with class \code{valid_idata_set}.
}
\description{
Validate and prepare data sets for simulation.

Validate and prepare idata data sets for simulation.
}
\seealso{
\code{\link{idata_set}}, \code{\link{data_set}},
\code{\link{valid_data_set}}
}
