% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsims.R
\docType{methods}
\name{mrgsims}
\alias{mrgsims}
\alias{$,mrgsims-method}
\alias{tail,mrgsims-method}
\alias{head,mrgsims-method}
\alias{dim,mrgsims-method}
\alias{names,mrgsims-method}
\alias{as.data.frame,mrgsims-method}
\alias{as.matrix,mrgsims-method}
\alias{summary.mrgsims}
\alias{show,mrgsims-method}
\title{Methods for working with \code{mrgsims} objects}
\usage{
\S4method{$}{mrgsims}(x, name)

\S4method{tail}{mrgsims}(x, ...)

\S4method{head}{mrgsims}(x, ...)

\S4method{dim}{mrgsims}(x)

\S4method{names}{mrgsims}(x)

\S4method{as.data.frame}{mrgsims}(x, row.names = NULL,
  optional = FALSE, ...)

\S4method{as.matrix}{mrgsims}(x, ...)

\method{summary}{mrgsims}(object, ...)

\S4method{show}{mrgsims}(object)
}
\arguments{
\item{x}{mrgsims object}

\item{name}{name of column of simulated output to retain}

\item{...}{passed to other functions}

\item{row.names}{passed to \code{\link{as.data.frame}}}

\item{optional}{passed to \code{\link{as.data.frame}}}

\item{object}{passed to show}
}
\description{
These methods help the user view simulation output and extract 
simulated data to work with further.  The methods listed here 
for the most part have generics defined by R or other R packages.  
See the \code{seealso} section for other methods defined 
by \code{mrgsolve} that have their own documentation pages.
}
\details{
Most methods should behave as expected according to other method 
commonly used in R (e.g. head, tail, as.data.frame, etc ...)

\itemize{
  \item{\code{$}} selects a column in the simulated data and 
  returns numeric
  \item{\code{head}} see \code{\link{head.matrix}}; returns 
  simulated data
  \item{\code{tail}} see \code{\link{tail.matrix}}; returns 
  simulated data
  \item{\code{dim}, \code{nrow}, \code{ncol}} returns dimensions, 
  number of rows, and number of columns in simulated data
  \item{\code{as.data.frame}} coerces simulated data to data.frame 
  and returns the data.frame
  \item{\code{as.matrix}} returns matrix of simulated data
  \item{\code{as.tbl}} coerces simulated to \code{tbl_df}; 
  requires \code{dplyr}
  \item{\code{summary}} coerces simulated data to data.frame 
  and passes to \code{\link{summary.data.frame}}
  \item{\code{plot}} plots simulated data; see \code{\link{plot_mrgsims}}
}
}
\examples{

## example("mrgsims")

mod <- mrgsolve:::house() \%>\% init(GUT=100)

out <- mrgsim(mod)

class(out)

\dontrun{
out
}
head(out)
tail(out)


dim(out)
names(out)

mat <- as.matrix(out)
df <- as.data.frame(out)

\dontrun{
out$CP
}

plot(out)
\dontrun{
plot(out, CP~.)
plot(out, CP+RESP~time, scales="same", xlab="Time", main="Model sims")
}
}
\seealso{
\code{\link{stime}}
}
\keyword{internal}
