% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_names_search.R
\name{mr_names_search}
\alias{mr_names_search}
\title{Search for region names}
\usage{
mr_names_search(x, q = NULL, ...)
}
\arguments{
\item{x, q}{Either a \code{tbl_df}, returned from \code{\link{mr_names}}, or
a query as a character string. If a \code{tbl_df}, you must pass a query
string to \code{q}. If a query string (character) is passed to \code{x},
leave \code{q} as \code{NULL}}

\item{...}{Parameters passed on to \code{\link{agrep}}}
}
\value{
\code{NULL} if no matches found, or a data.frame, or tibble, of class
\code{tbl_df}, with slots:
\itemize{
 \item name (character) - name of the region, which is a combination of the
 name_first and name_second, e.g., Morocco:elevation_10m
 \item title (character) - title for the region
 \item name_first (character) - first part of the name, e.g., Morocco
 \item name_second (character) - second part of the name, e.g., elevation_10m
}
}
\description{
Search for region names
}
\examples{
\dontrun{
# Get region names with mr_names() function
(res <- mr_names("MarineRegions:eez"))

# to save time, pass in the result from mr_names()
mr_names_search(res, q = "Amer")

# if you don't pass in the result from mr_names(), we have to
# call mr_names() internally, adding some time
mr_names_search(x = "iho", q = "Black")
mr_names_search(x = "iho", q = "Sea")

# more examples
mr_names_search("iho", "Sea")
(res <- mr_names("MarineRegions:iho"))
mr_names_search(res, q = "Sea")
}
}
