% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cds}
\alias{cds}
\title{CDS function definition}
\usage{
cds(key = NULL, adj.series = NULL, adj.order = NULL,
  adj.scale = "width", adj.exp = FALSE, formula = ~1,
  shape.formula = ~1)
}
\arguments{
\item{key}{string identifying key function (currently either "hn"
(half-normal),"hr" (hazard-rate), "unif" (uniform) or "gamma" (gamma
distribution)}

\item{adj.series}{string identifying adjustment functions cos (Cosine), herm
(Hermite polynomials), poly (simple polynomials) or NULL}

\item{adj.order}{vector of order of adjustment terms to include}

\item{adj.scale}{whether to scale the adjustment terms by "width" or "scale"}

\item{adj.exp}{if TRUE uses exp(adj) for adjustment to keep f(x)>0}

\item{formula}{formula for scale function (included for completeness only
only formula=~1 for cds)}

\item{shape.formula}{formula for shape function}
}
\value{
A formula list used to define the detection function model
  \item{fct}{string "cds"} \item{key}{key function string}
  \item{adj.series}{adjustment function string} \item{adj.order}{adjustment
  function orders} \item{adj.scale}{adjustment function scale type}
  \item{formula}{formula for scale function} \item{shape.formula}{formula
  for shape function}
}
\description{
Creates model formula list for conventional distance sampling using values
supplied in call to \code{\link{ddf}}
}
\author{
Jeff Laake; Dave Miller
}
\keyword{utility}

