% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{setDilutionFactors}
\alias{setDilutionFactors}
\title{A function for setting dilution factors.}
\usage{
setDilutionFactors(
  mrbinObject,
  dilutionFactors = NULL,
  errorsAsWarnings = FALSE,
  alwaysShowOptionKeep = FALSE,
  graphics = TRUE
)
}
\arguments{
\item{mrbinObject}{An mrbin object}

\item{dilutionFactors}{An optional vector of dilution factors. If provided, no user input is requested}

\item{errorsAsWarnings}{If TRUE, errors will be turned into warnings. Should be used with care, as errors indicate undocumented changes to the data.}

\item{alwaysShowOptionKeep}{If TRUE, you will be asked to keep current values even if they do not match the current dataset.}

\item{graphics}{Controls whether pop-up windows are shown for selections. Defaults to TRUE.}
}
\value{
An invisible mrbin object
}
\description{
This function edits the dilution factors of an mrbin object but does not change the bin data.
}
\examples{
 results<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,tryParallel=TRUE,
                   NMRfolders=c(system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/3/10/pdata/10",package="mrbin"))
                   ))
 results<-setDilutionFactors(results,dilutionFactors=c(1.5,2))
}
