% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_effect_QxEC.R
\name{QTL_effect_QxEC}
\alias{QTL_effect_QxEC}
\title{Estimation of QTL effect sensitivity to environmental covariates}
\usage{
QTL_effect_QxEC(
  mppData,
  trait,
  env_id = NULL,
  VCOV = "UN",
  ref_par = NULL,
  QTL = NULL,
  QmainQi = TRUE,
  thre_QTL = 2,
  all_main = TRUE,
  EC,
  Qmain_QxE = NULL,
  QTLxEC_plot = TRUE,
  maxIter = 100,
  msMaxIter = 100
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{env_id}{\code{Character} vector specifying the environment names.
By default, E1, ... En}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. Default = NULL}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected marker positions obtained with the function QTL_select() or
a vector of \code{character} marker positions names. Default = NULL.}

\item{QmainQi}{\code{logical} value specifying how the QTL parental allele
main effects are estimated. For further explanation see the details section.
Default = TRUE}

\item{thre_QTL}{\code{Numerical} value specifying the -log10(p-val) threshold
for a parental QTL allele to be considered as significant. By default,
thre_QTL = 2, which correspond to a p-value of 0.01.}

\item{all_main}{\code{Logical} value specifying if all the parental alleles
should be set as main effect in the QTLxEC model or if only the significant
parental allele should be introduced in the model as main effect and QTLxEC
effect if the QTLxE term is significant. Default = TRUE.}

\item{EC}{\code{Numeric} matrix with environments as row and environmental
covariates (EC) as column. The cell i, j of EC specify the value of the
jth EC in environment i.}

\item{Qmain_QxE}{results from \code{\link{QTL_effect_main_QxE}}}

\item{QTLxEC_plot}{\code{Logical} value specifying if the data to
plot sensitivity curve with the function plot_QTLxEC should be returned.
Default = TRUE}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}
}
\value{
Return:

\code{List} with one \code{data.frame} per QTL that contains the following
elements:

\enumerate{

\item{QTL parent allele main effect expressed as deviation with respect to
the reference parent}
\item{QTL parent allele effect in environment j expressed as deviation with
respect to the reference parent}
\item{Significance of the parent main effect expressed as the -log10(p-val)}

\item{Significance of the parent QTLxE effect expressed as the -log10(p-val)}

}
}
\description{
Determination of which parental QTL effect show a significant interaction
with the environment. Then, the function try to characterize the nature
of the QTLxE effect by estimating the sensitivity of the parental allelic
effects showing significant QTLxE interaction to environmental covariates
provided by the user.
}
\details{
The function first estimate the parental QTL allele main and QTLxE effect
using the function \code{\link{QTL_effect_main_QxE}}. Then it determines
which parental allele shows a significant QTLxE effect by looking if the
-log10(p-val) of the parental QTLxE effect is superior or equal to
\code{thre_QTL} and if the -log10(p-val) of QTLxE term is superior to one of
the main effect. Finally, given this information, the function replaces the
QTLxE term of the parental QTL allelic effect showing a significant QTLxE
effect with a main effect and QTLxEC term representing interaction between
the parental QTL allele and the environmental covariate (EC). The QTLxEC term can
be interpreted as a sensitivity of the QTL to the variation of the EC in the
different environments.

Two options are possible concerning the inclusion of the parental QTL allele
as main effect in the QTLxEC model. Either all parental allele are introduced
(\code{all_main = TRUE}, default), or only the parental allele showing a
singificant main effect are introduced (\code{all_main = FALSE}). 

The estimation is performed using an exact mixed model with function from R
package \code{nlme}. The significance of the allele effect is assessed using a 
Wald test.
}
\examples{

\dontrun{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

EC <- matrix(c(180, 310, 240, 280), 4, 1)
rownames(EC) <- c('CIAM', 'TUM', 'INRA', 'KWS')
colnames(EC) <- 'cum_rain'

Qeff <- QTL_effect_QxEC(mppData = mppData_GE,
                         trait = c('DMY_CIAM', 'DMY_TUM', 'DMY_INRA_P', 'DMY_KWS'),
                         env_id = c('CIAM', 'TUM', 'INRA', 'KWS'),
                         QTL = Qpos, EC = EC)

Qeff

}

}
\references{
Pinheiro J, Bates D, DebRoy S, Sarkar D, R Core Team (2021). nlme: Linear
and Nonlinear Mixed Effects Models_. R package version 3.1-152,
<URL: https://CRAN.R-project.org/package=nlme>.
}
\seealso{
\code{\link{QTL_effect_main_QxE}}
}
\author{
Vincent Garin
}
