% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplot-package.R
\docType{data}
\name{fev}
\alias{fev}
\title{Forced Expiratory Volume}
\format{A data frame with 654 observations on 5 variables.
\describe{
\item{age}{Age (years)}
\item{fev}{Forced expiratory volume (liters).  Roughly the amount
of air an individual can exhale in the first second of
a forceful breath.}
\item{height}{Height (inches).}
\item{sex}{Female is 0. Male is 1.}
\item{smoke}{A binary variable indicating whether or not the
youth smokes. Nonsmoker is 0. Smoker is 1.}
}}
\usage{
data(fev)
}
\description{
This data set consists of 654 observations on youths aged 3 to 19 from
East Boston recorded duing the middle to late 1970's.
Forced expiratory volume (FEV), a measure of lung capacity, is the
variable of interest. Age and height are two continuous predictors.
Sex and smoke are two categorical predictors.
}
\details{
Copies of this data set can also be found in the
\code{coneproj} and \code{tmle} packages.
}
\examples{
data(fev)
full.mod = lm(fev~.,data=fev)
step(full.mod)
}
\references{
Tager, I. B., Weiss, S. T., Rosner, B., and Speizer, F. E. (1979).
Effect of parental cigarette smoking on pulmonary function in children.
\emph{American Journal of Epidemiology}, \bold{110}, 15-26.

Rosner, B. (1999).
\emph{Fundamentals of Biostatistics}, 5th Ed., Pacific Grove, CA: Duxbury.

Kahn, M.J. (2005). An Exhalent Problem for Teaching Statistics.
\emph{Journal of Statistics Education},  \bold{13}(2).
http://www.amstat.org/publications/jse/v13n2/datasets.kahn.html
}
\keyword{datasets}
