% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_lambdas.R
\name{comp_lambdas}
\alias{comp_lambdas}
\alias{comp_lambdas_fixed_ub}
\title{Solve for Lambda for a Particular Mean Parametrized COM-Poisson Distribution}
\usage{
comp_lambdas(
  mu,
  nu,
  lambdalb = 1e-10,
  lambdaub = 1000,
  maxlambdaiter = 1000,
  tol = 1e-06,
  lambdaint = 1,
  summax = 100
)

comp_lambdas_fixed_ub(
  mu,
  nu,
  lambdalb = 1e-10,
  lambdaub = 1000,
  maxlambdaiter = 1000,
  tol = 1e-06,
  lambdaint = 1,
  summax = 100
)
}
\arguments{
\item{mu, nu}{mean and dispersion parameters. Must be straightly positive.}

\item{lambdalb, lambdaub}{numeric; the lower and upper end points for the interval to be
searched for lambda(s).}

\item{maxlambdaiter}{numeric; the maximum number of iterations allowed to solve
for lambda(s).}

\item{tol}{numeric; the convergence threshold. A lambda is said to satisfy the
mean constraint if the absolute difference between the calculated mean and the
corresponding mu values is less than tol.}

\item{lambdaint}{numeric vector; initial gauss for lambda(s).}

\item{summax}{maximum number of terms to be considered in the truncated sum}
}
\value{
Both \code{comp_lambdas} and \code{comp_lambdas_fixed_ub} returns the lambda value(s)
that satisfies the mean constraint(s) as well as the current lambdaub value.
lambda value(s) returns by \code{comp_lambdas_fixed_ub} is bounded by the lambdaub
value.
\code{comp_lambdas} has the extra ability to scale up/down lambdaub to find the most
appropriate lambda values.
}
\description{
Given a particular mean parametrized COM-Poisson distribution i.e. mu and nu,
this function is used to find a lambda that can satisfy the mean constraint with a
combination of bisection and Newton-Raphson updates. The function is also vectorized but
will only update those that have not converged.
}
