% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unzip_data}
\alias{unzip_data}
\title{Unzip m-Path Sense output}
\usage{
unzip_data(
  path = getwd(),
  overwrite = FALSE,
  recursive = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{path}{The path to the directory containing the zip files.}

\item{overwrite}{Logical value whether you want to overwrite already existing zip files.}

\item{recursive}{Logical value indicating whether to unzip files in subdirectories as well. These
files will then be unzipped in their respective subdirectory.}

\item{parallel}{A logical value whether you want to check in parallel. Useful when there are a
lot of files. If you have already used \code{future::plan}, you can leave this parameter to
\code{FALSE}.}
}
\value{
A message indicating how many files were unzipped.
}
\description{
Similar to \link[utils]{unzip}, but makes it easier to unzip all files in a given path
with one function call.
}
\section{Progress}{

You can be updated of the progress by this function by using the
\code{\link[progressr]{progress}} package. See \code{progressr}'s
\href{https://cran.r-project.org/package=progressr/vignettes/progressr-intro.html}{vignette}
on how to subscribe to these updates.
}

