#' mpathsenser: Process and Analyse Data from m-Path Sense
#'
#' Overcomes one of the major challenges in mobile (passive) sensing, namely
#' being able to pre-process the raw data that comes from a mobile sensing app,
#' specifically "m-Path Sense" <https://m-path.io>. The main task of 'mpathsenser' is
#' therefore to read "m-Path Sense" JSON files into a database and provide several
#' convenience functions to aid in data processing.
#'
#' @section Author(s):
#' \strong{Maintainer}: Koen Niemeijer \email{koen.niemeijer@@kuleuven.be}
#' (\href{https://orcid.org/0000-0002-0816-534X}{ORCID})
#'
#' Other contributors:
#' \itemize{
#'   \item KU Leuven \[copyright holder, funder\]
#' }
#'
#' @importFrom magrittr '%>%'
#' @docType package
#' @name mpathsenser
NULL
