% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedNumberOfFounderAlleles.R
\name{fixedNumberOfFounderAlleles}
\alias{fixedNumberOfFounderAlleles}
\title{Convert fully informative experiment to one with a fixed number of alleles per marker}
\usage{
fixedNumberOfFounderAlleles(alleles)
}
\arguments{
\item{alleles}{Number of alleles for each marker}
}
\value{
An object of internal class \code{fixedNumberOfFounderAlleles} suitable for application to an object of class \code{mpcross} using the addition operation.
}
\description{
Convert a fully informative experiment to one with a fixed number of alleles per marker
}
\details{
By default, simulated data is fully informative, so every founder carries its own allele, and all heterozygotes are distinguishable. 

This function takes in a fully informative experiment, and changes every marker so that it has a fixed number of founder alleles. Heterozygotes are also changed, so every combination of different alleles is still distinguishable.
}
\examples{
data(simulatedFourParentData)
founders(simulatedFourParentData)[, 1:10]
altered <- simulatedFourParentData + fixedNumberOfFounderAlleles(3)
founders(altered)[, 1:10]
}
