% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movecorr.R
\name{movecorr}
\alias{movecorr}
\title{R function for calculating least-cost corridor between two point locations}
\usage{
movecorr(
  dtm = NULL,
  a,
  b,
  lab.a = "A",
  lab.b = "B",
  cex.labs = 0.8,
  studyplot = NULL,
  funct = "t",
  time = "h",
  move = 16,
  sl.crit = 10,
  W = 70,
  L = 0,
  N = 1,
  V = 1.2,
  z = 9,
  export = FALSE
)
}
\arguments{
\item{dtm}{Digital Terrain Model (RasterLayer class); if not provided, elevation data will be acquired online for the area enclosed by the 'studyplot' parameter (see \code{\link{movecost}}).}

\item{a}{first location from which the least-cost corridor is calculated (SpatialPointsDataFrame class).}

\item{b}{second location from which the least-cost corridor is calculated (SpatialPointsDataFrame class).}

\item{lab.a}{string to be used to label point a on the outplut plot (A is the default)}

\item{lab.b}{string to be used to label point a on the outplut plot (B is the default).}

\item{cex.labs}{scaling factor for the size of the points' labels (0.8 by default)}

\item{studyplot}{polygon (SpatialPolygonDataFrame class) representing the study area for which online elevation data are aquired (see \code{\link{movecost}}); NULL is default.}

\item{funct}{cost function to be used (for details on each of the following, see \code{\link{movecost}}):\cr \strong{t} (default) uses the on-path Tobler's hiking function;\cr
\strong{tofp} uses the off-path Tobler's hiking function;\cr
\strong{mp} uses the Marquez-Perez et al.'s modified Tobler's function;\cr
\strong{icmonp} uses the Irmischer-Clarke's modified Tobler's hiking function (male, on-path);\cr
\strong{icmoffp} uses the Irmischer-Clarke's modified Tobler's hiking function (male, off-path);\cr
\strong{icfonp} uses the Irmischer-Clarke's modified Tobler's hiking function (female, on-path);\cr
\strong{icfoffp} uses the Irmischer-Clarke's modified Tobler's hiking function (female, off-path);\cr
\strong{ug} uses the Uriarte Gonzalez's slope-dependant walking-time cost function;\cr
\strong{alb} uses the Alberti's Tobler hiking function modified for animal foraging excursions;\cr
\strong{ree} uses the relative energetic expenditure cost function;\cr
\strong{hrz} uses the Herzog's metabolic cost function;\cr
\strong{wcs} uses the wheeled-vehicle critical slope cost function;\cr
\strong{p} uses the Pandolf et al.'s metabolic energy expenditure cost function;\cr
\strong{vl} uses the Van Leusen's metabolic energy expenditure cost function;\cr
\strong{ls} uses the Llobera-Sluckin's metabolic energy expenditure cost function.}

\item{time}{time-unit expressed by the accumulated raster if Tobler's and other time-related cost functions are used;
'h' for hour, 'm' for minutes.}

\item{move}{number of directions in which cells are connected: 4 (rook's case), 8 (queen's case), 16 (knight and one-cell queen moves; default).}

\item{sl.crit}{critical slope (in percent), typically in the range 8-16 (10 by default) (used by the wheeled-vehicle cost function; see \code{\link{movecost}}).}

\item{W}{walker's body weight (in Kg; 70 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{L}{carried load weight (in Kg; 0 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{N}{coefficient representing ease of movement (1 by default) (used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{V}{speed in m/s (1.2 by default) (used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{z}{zoom level for the elevation data downloaded from online sources (from 0 to 15; 9 by default) (see \code{\link{movecost}} and \code{\link[elevatr]{get_elev_raster}}).}

\item{export}{TRUE or FALSE (default) if the user wants or does not want the output to be exported; if TRUE, the least-cost corridor, the dtm (if not provided by the user but acquired online),
and the accumulated cost surface around a and b are exported as a GeoTiff file; the two LCPs (from a to b, and from b to a) as individual shapefiles.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{dtm: }{Digital Terrain Model ('RasterLayer' class)}
 \item{lc.corridor: }{raster of the least-cost corridor ('RasterLayer' class)}
 \item{lcp_a_to_b: }{least-cost past from a to b ('SpatialLines' class)}
 \item{lcp_b_to_a: }{least-cost past from b to a ('SpatialLines' class)}
 \item{accum_cost_surf_a: }{accumulated cost-surface around a ('RasterLayer' class)}
 \item{accum_cost_surf_b: }{accumulated cost-surface around b ('RasterLayer' class)}
}
}
\description{
The function provides the facility to calculate the least-cost corridor between two point locations. It just requires an inout DTM,
and two point locations ('SpatialPointsDataFrame' class) representing the locations between which the corridor is calculated. Under the
hood, 'movecorr' relies on the \code{\link{movecost}} function and, needless to say, implements the same
cost functions. See the help documentation of \code{\link{movecost}} for further details.  The function renders a raster representing
the least cost corridor (with least-cost paths superimposed), and returns a list containing a number of components (see 'Value' below). The corridor raster can be
exported as GeoTiff (see 'Arguments' below). \cr
}
\details{
What 'movecorr()' does is to calculate (via the \code{\link{movecost}} function) the accumulated cost surface around location
a, and then the accumulated cost surface around b. The two surfaces are eventually combined to produce the least-cost
corridor between location a and b. On the produced corridor raster, the cost of a cell is the total cost to reach it
from both locations. About least-cost corridors see for instance: \cr
Mitchell A. (2012), "The ESRI Guide to GIS Analysis. Vol 3. Modelling Suitability, Movement, and Interaction", New York: Esri Press (257-259).
}
\examples{
# load a sample Digital Terrain Model
volc <- raster::raster(system.file("external/maungawhau.grd", package="gdistance"))


# load the sample destination locations on the above DTM
data(destin.loc)

# calculate the least-cost corridor between two locations, using the
# relative energetic expenditure cost function, and store the results
# in the 'res' object

result <- movecorr(dtm=volc, a=destin.loc[1,], b=destin.loc[3,], funct="ree")


}
\seealso{
\code{\link{movecost}}
}
\keyword{movecorr}
