% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_raster.R
\name{animate_raster}
\alias{animate_raster}
\title{Animate raster data}
\usage{
animate_raster(layer, out_dir, conv_dir = "convert", layer_dt = 0,
  layer_type = "gradient", layer_stretch = "none",
  layer_col = c("sandybrown", "white", "darkgreen"), layer_nacol = "white",
  ...)
}
\arguments{
\item{layer}{list. List of raster objects.}

\item{out_dir}{character. Output directory of the output file.}

\item{conv_dir}{character. Command of or path to required image/video converter tool. Depends on, what is specified for \code{out_format}. If \code{out_format = "gif"}, animate_move() works with the ImageMagick \code{convert} tool. In this case, specify command of or path to the \code{convert} tool. You can use \code{\link{get_libraries}} to find or download/install \code{convert}. If \code{out_format} is a video format (e.g. "mp4", "mov" ...), animate_move() works with either the FFmpeg \code{ffmepg} tool or the libav \code{avconv} tool. In this case, specify command of or path to the \code{ffmpeg} or \code{avconv} tool. See also \code{\link{get_libraries}}. If not specified, animate_move() trys to find libraries automatically.}

\item{layer_dt}{POSIXct or vector. Optional vector of POSIXct date/time stamps corresponding to the acquisition dates of the \code{layer} raster objects to display a time scale.}

\item{layer_type}{charachter. Layer type. Either "\code{RGB}" (if layer is a rasterBrick class onejct), "\code{gradient}" or "\code{discrete}". Default is "\code{RGB}". Ignored, if \code{layer = "basemap"}.}

\item{layer_stretch}{character. Ignored, if \code{layer_type} is not "RGB". Either "none", "lin", "hist", "sqrt" or "log" for no stretch, linear, histogram, square-root or logarithmic stretch. Default is "none".}

\item{layer_col}{character vector.  Two or more colours to be used for displaying the background layer. If \code{layer_type = "gradient"}, a colour ramp between the colous is calcualted. If \code{layer_type = "discrete"}, the colours will be used per value range. Ignored, if \code{layer_type = "RGB"}.}

\item{layer_nacol}{character. Colour to be displayed for NA values. Default is "white".}

\item{...}{additional arguments, see \link{animate_move}.}
}
\value{
None or logical (see \code{log_logical}). The output GIF or video file is written to the ouput directory.
}
\description{
\code{animate_raster} animates raster data provided as list of \code{raster} class objects. The function creates an animated GIF or video file and saves it into the output directory.
}
\details{
\code{animate_raster} is based on \code{ggplot2}. Depending on the selected output format (\code{out_format}, it either needs the \code{convert} tool of the ImageMagick software package (.gif format) or either \code{ffmpeg} from FFmpeg or \code{avconv} from libav (video formats). The command or directory to the convert tool needs to be provided with \code{conv_dir}. Please use \code{\link{get_libraries}} to search for the needed libraries and command/tool directories on your system or to automatically download and install the required software. See \code{\link{get_libraries}} and \code{out_format} and \code{conv_dir} for details.
}
\examples{
\dontrun{
#Create a list of several raster objects to be displayed one after another
#If layer_type = RGB, use a brick class obejct with RGB bands!
layer <- list(raster1, raster2, raster2)

#Get your convert directory/command
conv_dir <- get_libraries()

#Specify the output directory, e.g.
out_dir <- "/out/test"
#or to a temporary directory:
out_dir <- paste0(tempdir(),"/test")
dir.create(out_dir)

#Call animate_raster
animate_raster(layer,out_dir = our_dir, conv_dir = conv_dir, layer_type = "RGB",
               out_format = "gif")
               
#use another file format for longer videos
animate_raster(layer,out_dir = our_dir, conv_dir = conv_dir, layer_type = "RGB",
               out_format = "mov")
}

}
\seealso{
\code{\link{get_libraries}}, \code{\link{animate_move}},
}
\author{
Jakob Schwalb-Willmann
}
