% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movebank_credentials.R
\name{movebank_store_credentials}
\alias{movebank_store_credentials}
\alias{movebank_remove_credentials}
\title{Store or remove credentials in the system keyring}
\usage{
movebank_store_credentials(
  username,
  password,
  key_name = getOption("move2_movebank_key_name"),
  force = FALSE
)

movebank_remove_credentials(key_name = getOption("move2_movebank_key_name"))
}
\arguments{
\item{username}{A string with the movebank username}

\item{password}{Either a string or missing, if missing then the password is asked for using
\code{\link[askpass]{askpass}}}

\item{key_name}{The name of the key in the keyring. By default this is stored in
\code{getOption("move2_movebank_key_name")}, this might be useful if you have multiple accounts}

\item{force}{If TRUE, when accessing movebank fails the key is stored anyway.}
}
\value{
\code{TRUE} invisible if successful
}
\description{
The function stores the credentials for accessing movebank, by default it checks if accessing movebank is possible,
and fails when either the credentials are invalid or movebank cannot be reached. The force option can be used to
override this. Once credentials are stored, these functions are not needed again as all call to movebank can use the
credentials from the keyring.

For more details on the usage of the keyring, how passwords are handled and handling multiple accounts see
\code{vignette("movebank", package="move2")}
}
\examples{
\dontrun{
movebank_store_credentials("bart")
}
}
\seealso{
Other movebank-download: 
\code{\link{movebank_download_study}()},
\code{\link{movebank_handle}()}
}
\concept{movebank-download}
